#include "settings.h"
#include <QtDBus/QDBusConnection>
#include <QtDBus/QDBusMessage>
#include <QtDBus/QDBusInterface>

Settings::Settings(QSettings *parent) :
    QSettings(QString("cuteTube-QML"), QString("cuteTube-QML"), parent) {
}

Settings::~Settings() {

}

void Settings::restoreSettings() {
    beginGroup("Widget");
    setYouTubeWidgetFeed(value("youtubeWidgetFeed", QString("_MOST_RECENT_FEED")).toString(), false);
    setDailymotionWidgetFeed(value("dailymotionWidgetFeed", QString("_DM_MOST_RECENT_FEED")).toString(), false);
    setMediaPlayer(value("mediaPlayer", QString("cutetubePlayer")).toString(), false);
    setSearchQuery(value("searchQuery", QString()).toString(), false);
    setSearchOrder(value("searchOrder", QString("published")).toString(), false);
    setDurationFilter(value("durationFilter", QString("all")).toString(), false);
    setTheme(QString("dark"));
    setActiveColor(value("activeColor", QString("#066bbe")).toString(), false);
    setActiveColorString(value("activeColorString", QString("color8")).toString(), false);
    endGroup();

    beginGroup("Appearance");
    setLanguage(value("language", QString("en")).toString());
    endGroup();

    beginGroup("System");
    setOrientation(value("screenOrientation", QString("auto")).toString());
    endGroup();
}

void Settings::saveSettings() {
    beginGroup("Widget");
    setValue("youtubeWidgetFeed", youtubeWidgetFeed);
    setValue("dailymotionWidgetFeed", dailymotionWidgetFeed);
    setValue("mediaPlayer", mediaPlayer);
    setValue("searchQuery", searchQuery);
    setValue("searchOrder", searchOrder);
    setValue("durationFilter", durationFilter);
    setValue("theme", theme);
    setValue("activeColor", activeColor);
    setValue("activeColorString", activeColorString);
    setValue("gradientColor", gradientColor);
    setValue("gradientColorHigh", gradientColorHigh);
    endGroup();
}

void Settings::updateWidgetSetting(const QString &method, const QString &arg) {
    QDBusConnection bus = QDBusConnection::sessionBus();
    QDBusInterface dbus_iface("com.marxian.cuteTubeWidget", "/", "com.marxian.cuteTubeWidget", bus);
    dbus_iface.call(method, arg);
}

void Settings::setYouTubeWidgetFeed(const QString &feed, bool update) {
    youtubeWidgetFeed = feed;
    emit youtubeWidgetFeedChanged();
    if (update) {
        updateWidgetSetting("setYouTubeWidgetFeed", feed);
    }
}

void Settings::setDailymotionWidgetFeed(const QString &feed, bool update) {
    dailymotionWidgetFeed = feed;
    emit dailymotionWidgetFeedChanged();
    if (update) {
        updateWidgetSetting("setDailymotionWidgetFeed", feed);
    }
}

void Settings::setSearchQuery(const QString &query, bool update) {
    searchQuery = query;
    emit searchQueryChanged();
    if (update) {
        updateWidgetSetting("setSearchQuery", query);
    }
}

void Settings::setSearchOrder(const QString &order, bool update) {
    searchOrder = order;
    emit searchOrderChanged();
    if (update) {
        updateWidgetSetting("setSearchOrder", order);
    }
}

void Settings::setDurationFilter(const QString &filter, bool update) {
    durationFilter = filter;
    emit durationFilterChanged();
    if (update) {
        updateWidgetSetting("setDurationFilter", filter);
    }
}

void Settings::setTheme(const QString &aTheme) {
    theme = aTheme;
    if (aTheme == "light") {
        setGradientColor(QString("#edece8"));
        setGradientColorHigh("white");
    }
    else {
        setGradientColor(QString("black"));
        setGradientColorHigh("#524e4e");
    }
    updateWidgetSetting("setTheme", aTheme);
    emit themeChanged();
}

void Settings::setActiveColor(const QString &color, bool update) {
    activeColor = color;
    emit activeColorChanged();
    if (update) {
        updateWidgetSetting("setActiveColor", color);
    }
}

void Settings::setActiveColorString(const QString &colorString, bool update) {
    activeColorString = colorString;
    emit activeColorStringChanged();
    if (update) {
        updateWidgetSetting("setActiveColorString", colorString);
    }
}

void Settings::setGradientColor(const QString &color) {
    gradientColor = color;
    emit gradientColorChanged();
}

void Settings::setGradientColorHigh(const QString &color) {
    gradientColorHigh = color;
    emit gradientColorHighChanged();
}

void Settings::setMediaPlayer(const QString &player, bool update) {
    mediaPlayer = player;
    emit mediaPlayerChanged();
    if (update) {
        updateWidgetSetting("setMediaPlayer", player);
    }
}

void Settings::setLanguage(const QString &lang) {
    language = lang;
}

void Settings::setOrientation(const QString &orientation) {
    screenOrientation = orientation;
    emit orientationChanged(orientation);
}
