import QtQuick 1.0
import "components"
import "scripts/widget.js" as Videos

Item {
    id: root

    width: 390
    height: 349

    property string youtubeFeed: _MOST_RECENT_FEED
    property string dailymotionFeed: _DM_MOST_RECENT_FEED
    property Item youtubePage: null
    property Item dailymotionPage: null
    property Item archivePage: null

    property int _SMALL_FONT_SIZE: 14
    property int _STANDARD_FONT_SIZE: 18
    property int _LARGE_FONT_SIZE: 24
    property string _TEXT_COLOR: Settings.appTheme == "light" ? "black" : "white"
    property string _BACKGROUND_COLOR: Settings.appTheme == "light" ? "white" : "black"

    /* YouTube feeds */

    property string _UPLOADS_FEED: "http://gdata.youtube.com/feeds/api/users/default/uploads?v=2&max-results=30&alt=json"
    property string _FAVOURITES_FEED: "http://gdata.youtube.com/feeds/api/users/default/favorites?v=2&max-results=30&alt=json"
    property string _NEW_SUB_VIDEOS_FEED: "http://gdata.youtube.com/feeds/api/users/default/newsubscriptionvideos?v=2&max-results=30&alt=json"
    property string _MOST_RECENT_FEED: "http://gdata.youtube.com/feeds/api/standardfeeds/most_recent?v=2&max-results=30&alt=json"
    property string _WATCH_LATER_FEED: "http://gdata.youtube.com/feeds/api/users/default/watch_later?v=2&max-results=30&alt=json"
    property string _RECOMMENDED_FEED: "http://gdata.youtube.com/feeds/api/users/default/recommendations?v=2&max-results=30&alt=json"

    /* Dailymotion feeds */

    property string _DM_UPLOADS_FEED: "https://api.dailymotion.com/me/videos?limit=30&family_filter=" + Settings.safeSearch.toString() + "&fields=" + _DM_VIDEO_FIELDS
    property string _DM_FAVOURITES_FEED: "https://api.dailymotion.com/me/favorites?limit=30&fields=" + _DM_VIDEO_FIELDS
    property string _DM_NEW_SUB_VIDEOS_FEED: "https://api.dailymotion.com/me/subscriptions?limit=30&family_filter=" + Settings.safeSearch.toString() + "&fields=" + _DM_VIDEO_FIELDS
    property string _DM_MOST_RECENT_FEED: "https://api.dailymotion.com/videos?sort=recent&limit=30&family_filter=" + Settings.safeSearch.toString() + "&fields=" + _DM_VIDEO_FIELDS
    property string _DM_VIDEO_FIELDS: "id,url,title,duration,thumbnail_medium_url,rating,ratings_total,views_total"

    function youtubeSearch() {
        return Videos.getYouTubeSearch(Settings.searchQuery, Settings.searchOrder, Settings.durationFilter);
    }

    function dailymotionSearch() {
        return Videos.getDailymotionSearch(Settings.searchQuery, Settings.searchOrder);
    }

    function setWidgetFeeds() {
        youtubeFeed = eval("(" + Settings.youtubeWidgetFeed + ")");
        dailymotionFeed = eval("(" + Settings.dailymotionWidgetFeed + ")");
    }

    function refreshWidget() {
        setWidgetFeeds();
        if (tabGroup.currentTab == youtubePage) {
            if (youtubePage === null) {
                loadYouTubeVideos();
            }
            else {
                youtubePage.setVideoFeed(youtubeFeed);
            }
        }
        else if (tabGroup.currentTab == dailymotionPage) {
            if (dailymotionPage === null) {
                loadDailymotionVideos();
            }
            else {
                dailymotionPage.setVideoFeed(dailymotionFeed);
            }
        }
        else {
            if (archivePage === null) {
                loadArchiveVideos();
            }
            else {
                archivePage.refresh();
            }
        }
    }

    function loadYouTubeVideos() {
        youtubePage = tabGroup.addTab(Qt.resolvedUrl("YTWidgetListPage.qml"), 0);
        youtubePage.setVideoFeed(youtubeFeed);
    }

    function loadDailymotionVideos() {
        dailymotionPage = tabGroup.addTab(Qt.resolvedUrl("DMWidgetListPage.qml"), 1);
        dailymotionPage.setVideoFeed(dailymotionFeed);
    }

    function loadArchiveVideos() {
        archivePage = tabGroup.addTab(Qt.resolvedUrl("ArchiveWidgetPage.qml"), 2);
    }

    function playVideo(url, videoId, site) {
        if ((Settings.mediaPlayer == "cutetubePlayer") || (site == "archive")) {
            Utils.playVideo(url);
        }
        else if (site == "youtube") {
            YouTube.getVideoUrl(videoId);
        }
        else if (site == "dailymotion") {
            Dailymotion.getVideoUrl(videoId);
        }
    }

    Component.onCompleted: {
        setWidgetFeeds();
        loadArchiveVideos();
    }

    Connections {
        target: Settings
        onRefreshWidget: refreshWidget()
    }

    Rectangle {
        anchors.fill: parent
        color: _BACKGROUND_COLOR
        opacity: 0.7
    }

    TabGroup {
        id: tabGroup

        anchors { fill: parent; topMargin: tabBar.height; bottomMargin: navBar.height }
    }

    TabBar {
        id: tabBar

        anchors { left: parent.left; right: parent.right; top: parent.top }

        buttons: [
            TabButton {
                text: "YouTube"
                checked: tabGroup.index == 0
                onClicked: if (youtubePage === null) loadYouTubeVideos(); else tabGroup.setTab(0);
            },

            TabButton {
                text: "Dailymotion"
                checked: tabGroup.index == 1
                onClicked: if (dailymotionPage === null) loadDailymotionVideos(); else tabGroup.setTab(1);
            },

            TabButton {
                text: "Archive"
                checked: tabGroup.index == 2
                onClicked: if (archivePage === null) loadArchiveVideos(); else tabGroup.setTab(2);
            }
        ]
    }

    TabBar {
        id: navBar

        anchors { left: parent.left; right: parent.right; bottom: parent.bottom }
        separatorPosition: "top"
        buttons: [
            TabButton {
                iconSource: "images/up-white.png"
                enabled: tabGroup.currentTab !== null
                onClicked: tabGroup.currentTab.up()
            },

            TabButton {
                iconSource: "images/widget-refresh-white.png"
                enabled: (tabGroup.currentTab !== null) && (!tabGroup.currentTab.loading)
                onClicked: refreshWidget()
            },

            TabButton {
                iconSource: "images/down-white.png"
                enabled: tabGroup.currentTab !== null
                onClicked: tabGroup.currentTab.down()
            }
        ]
    }
}
