import QtQuick 1.0
import "components"
import "scripts/createobject.js" as ObjectCreator
import "scripts/videolistscripts.js" as Scripts

Page {
    id: root

    function selectAll() {
        Scripts.selectAll()
    }

    function selectNone() {
        Scripts.selectNone();
    }

    function addVideosToPlaybackQueue() {
        var list = [];
        for (var i = 0; i < videoList.checkList.length; i++) {
            list.push(ObjectCreator.cloneObject(videoListModel.get(videoList.checkList[i])));
        }
        playVideos(list);
        videoList.checkList = [];
    }

    function addVideosToDownloadQueue(convertToAudio) {
        var list = [];
        for (var i = 0; i < videoList.checkList.length; i++) {
            list.push(ObjectCreator.cloneObject(videoListModel.get(videoList.checkList[i])));
        }
        appendDownloadQueue(list, convertToAudio);
        videoList.checkList = [];
    }

    title: qsTr("XTube Search")
    tools: Menu {

        menuItems: [

            MenuSearchItem {
                id: searchItem

                placeholderText: qsTr("Search")
                onClicked: {
                    videoListModel.clear();
                    XTube.search(text);
                }
                onSearch: {
                    videoListModel.clear();
                    XTube.search(text);
                }
            },

            MenuItem {
                text: videoList.checkList.length === 0 ? qsTr("Select all") : qsTr("Select none")
                closeMenuWhenClicked: false
                enabled: videoList.count > 0
                onClicked: videoList.checkList.length === 0 ? selectAll() : selectNone()
            },

            MenuItem {
                text: qsTr("Play")
                visible: Settings.mediaPlayer == "cutetubePlayer"
                enabled: videoList.checkList.length > 0
                onClicked: addVideosToPlaybackQueue()
            },

            MenuItem {
                text: qsTr("Download")
                enabled: videoList.checkList.length > 0
                onClicked: addVideosToDownloadQueue(false)
            },

            MenuItem {
                text: qsTr("Download (audio)")
                enabled: videoList.checkList.length > 0
                onClicked: addVideosToDownloadQueue(true)
            }
        ]
    }

    Connections {
        target: XTube
        onGotVideos: videoListModel.addVideos(videos)
    }

    Timer {
        id: videoListTimer

        interval: 3000
        onTriggered: videoListModel.reset()
    }

    ListView {
        id: videoList

        property variant checkList : []

        anchors.fill: parent
        boundsBehavior: Flickable.DragOverBounds
        highlightRangeMode: ListView.StrictlyEnforceRange
        cacheBuffer: 2500
        clip: true
        onCurrentIndexChanged: if ((videoList.currentIndex > 0) && (videoList.count - videoList.currentIndex == 1) && (!XTube.loading)) XTube.getMoreVideos();
        footer: Item {
            id: footer

            width: videoList.width
            height: 100
            visible: XTube.loading
            opacity: footer.visible ? 1 : 0

            BusyDialog {
                anchors.centerIn: footer
                opacity: footer.opacity
            }
        }

        model: ListModel {
            id: videoListModel

            function addVideos(videos) {
                for (var i = 0; i < videos.length; i++) {
                    videoListModel.append(videos[i]);
                }
            }
        }

        delegate: XTubeListDelegate {
            id: delegate

            function addOrRemoveFromCheckList() {
                var cl = videoList.checkList;
                if (!delegate.checked) {
                    cl.push(index);
                }
                else {
                    for (var i = 0; i < cl.length; i++) {
                        if (cl[i] == index) {
                            cl.splice(i, 1);
                        }
                    }
                }
                videoList.checkList = cl;
            }

            checked: Scripts.indexInCheckList(index)
            onClicked: addOrRemoveFromCheckList();
            onPressAndHold: addOrRemoveFromCheckList()
            onPlayClicked: if (videoList.checkList.length === 0) playVideos([ObjectCreator.cloneObject(videoListModel.get(index))]);
        }

        ScrollBar {}
    }

    Label {
        id: noResultsText

        anchors { fill: videoList; margins: 10 }
        font.pixelSize: _LARGE_FONT_SIZE
        font.bold: true
        color: "#4d4d4d"
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        wrapMode: Text.WordWrap
        text: qsTr("No videos found. Tap menu to search")
        visible: (!XTube.loading) && (videoListModel.count == 0)
    }
}
