import QtQuick 1.0
import Models 1.0
import "components"
import "scripts/createobject.js" as ObjectCreator

QueryDialog {
    id: root

    property bool showFiles: false
    property string startFolder: Settings.downloadPath

    signal fileChosen(string filePath)

    function createModel() {
        fileList.model = ObjectCreator.createObject(Qt.resolvedUrl("FileListModel.qml"), fileList);
        fileList.model.folder = "file://" + startFolder;
        fileList.model.showFiles = showFiles;
    }

    function setFile() {
        var file = fileList.chosenFile.slice(7);
        fileChosen(file);
    }

    function setDownloadPath() {
        var path = fileList.model.folder.toString().slice(7);
        var isCuteTube = /cutetube/i.test(path);
        if (path.slice(path.length - 1) != "/") {
            if (isCuteTube) {
                Settings.downloadPath = path + "/";
            }
            else {
                Settings.downloadPath = path + "/cuteTube-QML/";
            }
        }
        else if (isCuteTube) {
            Settings.downloadPath = path;
        }
        else {
            Settings.downloadPath = path + "cuteTube-QML/";
        }
    }

    Component.onCompleted: initialiseTimer.restart()

    Timer {
        id: initialiseTimer

        interval: 500
        onTriggered: createModel()
    }

    acceptButtonText: folderText.text == "" ? "" : qsTr("Select")
    rejectButtonText: qsTr("Cancel")
    onAccepted: showFiles ? setFile() : setDownloadPath()
    content: Item {
        anchors.fill: parent

        Label {
            id: folderText

            anchors { left: parent.left; right: parent.right; top: parent.top; margins: 10 }
            font.bold: true
            elide: Text.ElideRight
            color: Settings.activeColor
            text: !fileList.model ? "" : showFiles ? fileList.chosenFile.slice(fileList.chosenFile.lastIndexOf("/") + 1) : fileList.model.folder.toString().slice(7)
        }

        ListView {
            id: fileList

            property string chosenFile: ""

            anchors { fill: parent; topMargin: 50; bottomMargin: 70 }
            clip: true
            boundsBehavior: Flickable.DragOverBounds
            delegate: FileBrowserDelegate {
                id: delegate

                onClicked: fileList.model.isFolder(index) ? fileList.model.folder = filePath : fileList.chosenFile = filePath
            }
        }

        Label {
            id: noResultsText

            anchors.centerIn: parent
            font.pixelSize: _LARGE_FONT_SIZE
            font.bold: true
            color: "#4d4d4d"
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            text: qsTr("Folder empty")
            visible: (fileList.model) && (fileList.count == 0) ? true : false
        }

        BusyDialog {
            anchors.centerIn: parent
            visible: !fileList.model
        }

        ToolIcon {
            id: backButton

            anchors { left: parent.left; bottom: parent.bottom }
            iconSource: Settings.appTheme == "light" ? "images/back.png" : "images/back-white.png"
            enabled: fileList.model ? true : false
            onClicked: fileList.model.folder = fileList.model.parentFolder
        }
    }
}
