import QtQuick 1.0
import "components"
import "scripts/createobject.js" as ObjectCreator

Page {
    id: root

    property Item profilePage: null
    property Item uploadsPage: null
    property Item favouritesPage: null
    property Item playlistsPage: null
    property Item groupsPage: null
    property Item subscriptionsPage: null

    function getUserProfile(user) {
        profilePage = tabGroup.addTab(Qt.resolvedUrl("DMUserProfilePage.qml"), 0);
        profilePage.tools = null;
        profilePage.getUserProfile(user);
    }

    function loadUploads() {
        uploadsPage = tabGroup.addTab(Qt.resolvedUrl("DMListPage.qml"), 1);
        uploadsPage.title = qsTr("Uploads");
        uploadsPage.enableSearch = true;
        uploadsPage.setVideoFeed("https://api.dailymotion.com/user/" + profilePage.user.id + "/videos?limit=30&family_filter=" + Settings.safeSearch.toString() + "&fields=" + _DM_VIDEO_FIELDS);
    }

    function loadFavourites() {
        favouritesPage = tabGroup.addTab(Qt.resolvedUrl("DMListPage.qml"), 2);
        favouritesPage.title = qsTr("Favourites");
        favouritesPage.setVideoFeed("https://api.dailymotion.com/user/" + profilePage.user.id + "/favorites?limit=30&family_filter=" + Settings.safeSearch.toString() + "&fields=" + _DM_VIDEO_FIELDS);
    }

    function loadPlaylists() {
        playlistsPage = tabGroup.addTab(Qt.resolvedUrl("DMPlaylistsPage.qml"), 3);
        playlistsPage.setPlaylistFeed("https://api.dailymotion.com/user/" + profilePage.user.id + "/playlists?limit=30&fields=" + _DM_PLAYLIST_FIELDS);
    }

    function loadGroups() {
        groupsPage = tabGroup.addTab(Qt.resolvedUrl("DMGroupsPage.qml"), 4);
        groupsPage.setGroupFeed("https://api.dailymotion.com/user/" + profilePage.user.id + "/groups?limit=30&fields=" + _DM_PLAYLIST_FIELDS);
    }

    function loadSubscriptions() {
        subscriptionsPage = tabGroup.addTab(Qt.resolvedUrl("DMSubscriptionsPage.qml"), 5);
        subscriptionsPage.setSubscriptionsFeed("https://api.dailymotion.com/user/" + profilePage.user.id + "/following?limit=30&fields=" + _DM_USER_FIELDS);
    }

    title: tabGroup.currentTab === null ? "" : tabGroup.currentTab.title
    tools: tabGroup.currentTab === null ? null : tabGroup.currentTab.tools

    Connections {
        target: Dailymotion
        onFollowed: {
            if ((pageStack.currentPage == root) && (profilePage !== null)) {
                profilePage.isSubscribed = true;
                messages.displayMessage(qsTr("You have subscribed to") + " '" + profilePage.user.screenname + "'");
            }
        }
        onUnfollowed: {
            if ((pageStack.currentPage == root) && (profilePage !== null)) {
                profilePage.isSubscribed = false;
                messages.displayMessage(qsTr("You have unsubscribed to") + " '" + profilePage.user.screenname + "'");
            }
        }
    }

    TabGroup {
        id: tabGroup

        anchors { fill: parent; topMargin: titleArea.height + tabBar.height }
    }

    TabBar {
        id: tabBar

        anchors { left: parent.left; right: parent.right; top: parent.top; topMargin: titleArea.height }

        buttons: [
            TabButton {
                iconSource: checked ? "images/contact-" + Settings.activeColorString + ".png" : Settings.appTheme == "light" ? "images/contact.png" : "images/contact-white.png"
                checked: tabGroup.currentTab == profilePage
                onClicked: tabGroup.setTab(0)
            },

            TabButton {
                iconSource: checked ? "images/transfer-upload-" + Settings.activeColorString + ".png" : Settings.appTheme == "light" ? "images/transfer-upload.png" : "images/transfer-upload-white.png"
                checked: tabGroup.currentTab == uploadsPage
                onClicked: if (uploadsPage === null) loadUploads(); else tabGroup.setTab(1);
            },

            TabButton {
                iconSource: checked ? "images/favourite-" + Settings.activeColorString + ".png" : Settings.appTheme == "light" ? "images/favourite.png" : "images/favourite-white.png"
                checked: tabGroup.currentTab == favouritesPage
                onClicked: if (favouritesPage === null) loadFavourites(); else tabGroup.setTab(2);
            },

            TabButton {
                iconSource: checked ? "images/list-" + Settings.activeColorString + ".png" : Settings.appTheme == "light" ? "images/list.png" : "images/list-white.png"
                checked: tabGroup.currentTab == playlistsPage
                onClicked: if (playlistsPage === null) loadPlaylists(); else tabGroup.setTab(3);
            },

            TabButton {
                iconSource: checked ? "images/groups-" + Settings.activeColorString + ".png" : Settings.appTheme == "light" ? "images/groups.png" : "images/groups-white.png"
                checked: tabGroup.currentTab == groupsPage
                onClicked: if (groupsPage === null) loadGroups(); else tabGroup.setTab(4);
            },

            TabButton {
                iconSource: checked ? "images/subscriptions-" + Settings.activeColorString + ".png" : Settings.appTheme == "light" ? "images/subscriptions.png" : "images/subscriptions-white.png"
                checked: tabGroup.currentTab == subscriptionsPage
                onClicked: if (subscriptionsPage === null) loadSubscriptions(); else tabGroup.setTab(5);
            }
        ]
    }
}
