import QtQuick 1.0
import "components"
import "scripts/createobject.js" as ObjectCreator

Page {
    id: root

    property Item profilePage: null
    property Item uploadsPage: null
    property Item favouritesPage: null
    property Item playlistsPage: null
    property Item groupsPage: null
    property Item subscriptionsPage: null

    function loadProfile() {
        profilePage = tabGroup.addTab(Qt.resolvedUrl("DMUserProfilePage.qml"), 0);
        profilePage.title = qsTr("My Profile");
        profilePage.getUserProfile(Dailymotion.username);
    }

    function loadUploads() {
        uploadsPage = tabGroup.addTab(Qt.resolvedUrl("DMListPage.qml"), 1);
        uploadsPage.title = qsTr("My Uploads");
        uploadsPage.enableSearch = true;
        uploadsPage.setVideoFeed(_DM_UPLOADS_FEED);
    }

    function loadFavourites() {
        favouritesPage = tabGroup.addTab(Qt.resolvedUrl("DMListPage.qml"), 2);
        favouritesPage.title = qsTr("My Favourites")
        favouritesPage.showingFavourites = true;
        favouritesPage.setVideoFeed(_DM_FAVOURITES_FEED);
    }

    function loadPlaylists() {
        playlistsPage = tabGroup.addTab(Qt.resolvedUrl("DMUserPlaylistsPage.qml"), 3);
    }

    function loadGroups() {
        groupsPage = tabGroup.addTab(Qt.resolvedUrl("DMUserGroupsPage.qml"), 4);
    }

    function loadSubscriptions() {
        subscriptionsPage = tabGroup.addTab(Qt.resolvedUrl("DMUserSubscriptionsPage.qml"), 5);
    }

    Component.onCompleted: loadProfile()

    title: tabGroup.currentTab === null ? "" : tabGroup.currentTab.title
    tools: tabGroup.currentTab === null ? null : tabGroup.currentTab.tools

    TabGroup {
        id: tabGroup

        anchors { fill: parent; topMargin: titleArea.height + tabBar.height }
    }

    TabBar {
        id: tabBar

        anchors { left: parent.left; right: parent.right; top: parent.top; topMargin: titleArea.height }

        buttons: [
            TabButton {
                iconSource: checked ? "images/contact-" + Settings.activeColorString + ".png" : Settings.appTheme == "light" ? "images/contact.png" : "images/contact-white.png"
                checked: tabGroup.currentTab == profilePage
                onClicked: tabGroup.setTab(0)
            },

            TabButton {
                iconSource: checked ? "images/transfer-upload-" + Settings.activeColorString + ".png" : Settings.appTheme == "light" ? "images/transfer-upload.png" : "images/transfer-upload-white.png"
                checked: tabGroup.currentTab == uploadsPage
                onClicked: if (uploadsPage === null) loadUploads(); else tabGroup.setTab(1);
            },

            TabButton {
                iconSource: checked ? "images/favourite-" + Settings.activeColorString + ".png" : Settings.appTheme == "light" ? "images/favourite.png" : "images/favourite-white.png"
                checked: tabGroup.currentTab == favouritesPage
                onClicked: if (favouritesPage === null) loadFavourites(); else tabGroup.setTab(2);
            },

            TabButton {
                iconSource: checked ? "images/list-" + Settings.activeColorString + ".png" : Settings.appTheme == "light" ? "images/list.png" : "images/list-white.png"
                checked: tabGroup.currentTab == playlistsPage
                onClicked: if (playlistsPage === null) loadPlaylists(); else tabGroup.setTab(3);
            },

            TabButton {
                iconSource: checked ? "images/groups-" + Settings.activeColorString + ".png" : Settings.appTheme == "light" ? "images/groups.png" : "images/groups-white.png"
                checked: tabGroup.currentTab == groupsPage
                onClicked: if (groupsPage === null) loadGroups(); else tabGroup.setTab(4);
            },

            TabButton {
                iconSource: checked ? "images/subscriptions-" + Settings.activeColorString + ".png" : Settings.appTheme == "light" ? "images/subscriptions.png" : "images/subscriptions-white.png"
                checked: tabGroup.currentTab == subscriptionsPage
                onClicked: if (subscriptionsPage === null) loadSubscriptions(); else tabGroup.setTab(5);
            }
        ]
    }
}
