import QtQuick 1.0
import "components"

Item {
    id: delegate

    property bool checked

    signal clicked
    signal pressAndHold

    width: parent.width
    height: 100

    ListHighlight {
        visible: (mouseArea.pressed) || (delegate.checked)
    }

    Label {
        id: titleText

        height: 90
        anchors { left: frame.right; leftMargin: 5; right: delegate.right; rightMargin: 5; top: delegate.top; topMargin: 5 }
        wrapMode: Text.WordWrap
        
        font.bold: true
        clip: true
        text: fileName.slice(0, fileName.lastIndexOf("."))
    }

    Image {
        id: frame

        z: 1
        width: 122
        height: 92
        anchors { left: delegate.left; leftMargin: 5; verticalCenter: delegate.verticalCenter }
        source: "images/frame.png"
        sourceSize.width: width
        sourceSize.height: height
        smooth: true

        Image {
            id: thumb

            z: -1
            anchors.fill: frame
            source: Settings.downloadPath + ".thumbnails/" + fileName.slice(0, fileName.lastIndexOf(".")) + ".jpg"
            smooth: true
            asynchronous: true
            onStatusChanged: if (thumb.status == Image.Error) thumb.source = Settings.appTheme == "light" ? "images/video.png" : "images/video-white.png";
        }
    }

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        onClicked: parent.clicked()
        onPressAndHold: parent.pressAndHold()
    }
}

