#include "settings.h"
#include <QDesktopServices>

Settings::Settings(QSettings *parent) :
    QSettings(QString("cuteTube-QML"), QString("cuteTube-QML"), parent) {
}

Settings::~Settings() {

}

void Settings::restoreSettings() {
    beginGroup("Widget");
    setYouTubeWidgetFeed(value("youtubeWidgetFeed", QString("_MOST_RECENT_FEED")).toString());
    setDailymotionWidgetFeed(value("dailymotionWidgetFeed", QString("_DM_MOST_RECENT_FEED")).toString());
    setMediaPlayer(value("mediaPlayer", QString("cutetubePlayer")).toString());
    setSearchQuery(value("searchQuery", QString()).toString());
    setSearchOrder(value("searchOrder", QString("published")).toString());
    setDurationFilter(value("durationFilter", QString("all")).toString());
    setTheme(QString("dark"));
    setActiveColor(value("activeColor", QString("#066bbe")).toString());
    setActiveColorString(value("activeColorString", QString("color8")).toString());
    endGroup();

    beginGroup("Transfers");
    setDownloadPath(value("downloadPath", QDesktopServices::storageLocation(QDesktopServices::DocumentsLocation).append("/cuteTube-QML/")).toString());
    endGroup();

    beginGroup("Search");
    setSafeSearch(value("safeSearch", false).toBool());
    endGroup();

    beginGroup("Appearance");
    setLanguage(value("language", QString("en")).toString());
    endGroup();

    beginGroup("Accounts");
    setYouTubeUsername(value("youtubeUsername", QString()).toString());
    setYouTubeAccessToken(value("youtubeAccessToken", youtubeAccessToken).toString());
    setDailymotionAccount(value("dailymotionUsername", QString()).toString(), value("dailymotionAccessToken", QString()).toString(), value("dailymotionRefreshToken", QString()).toString(), 0);
    endGroup();
}

void Settings::refresh() {
    emit refreshWidget();
}

void Settings::updateArchive() {
    emit archiveUpdated();
}

void Settings::setDownloadPath(const QString &path) {
    downloadPath = path;
    emit downloadPathChanged();
}

void Settings::setYouTubeWidgetFeed(const QString &feed) {
    youtubeWidgetFeed = feed;
    emit youtubeWidgetFeedChanged();
}

void Settings::setDailymotionWidgetFeed(const QString &feed) {
    dailymotionWidgetFeed = feed;
    emit dailymotionWidgetFeedChanged();
}

void Settings::setSearchQuery(const QString &query) {
    searchQuery = query;
    emit searchQueryChanged();
}

void Settings::setSafeSearch(bool safe) {
    safeSearch = safe;
    emit safeSearchChanged();
}

void Settings::setSearchOrder(const QString &order) {
    searchOrder = order;
    emit searchOrderChanged();
}

void Settings::setDurationFilter(const QString &filter) {
    durationFilter = filter;
    emit durationFilterChanged();
}

void Settings::setLanguage(const QString &lang) {
    language = lang;
}

void Settings::setTheme(const QString &aTheme) {
    theme = aTheme;
    if (aTheme == "light") {
        setGradientColor(QString("#edece8"));
        setGradientColorHigh("white");
    }
    else {
        setGradientColor(QString("black"));
        setGradientColorHigh("#524e4e");
    }
    emit themeChanged();
}

void Settings::setActiveColor(const QString &color) {
    activeColor = color;
    emit activeColorChanged();
}

void Settings::setActiveColorString(const QString &colorString) {
    activeColorString = colorString;
    emit activeColorStringChanged();
}

void Settings::setGradientColor(const QString &color) {
    gradientColor = color;
    emit gradientColorChanged();
}

void Settings::setGradientColorHigh(const QString &color) {
    gradientColorHigh = color;
    emit gradientColorHighChanged();
}

void Settings::setMediaPlayer(const QString &player) {
    mediaPlayer = player;
    emit mediaPlayerChanged(player);
}

void Settings::setYouTubeUsername(const QString &user) {
    youtubeUsername = user;
    emit youtubeUsernameChanged(user);
}

void Settings::setYouTubeAccessToken(const QString &token) {
    youtubeAccessToken = token;
    emit youtubeAccessTokenChanged(token);
}

void Settings::setDailymotionAccount(const QString &user, const QString &aToken, const QString &rToken, int tokenExpiry) {
    dailymotionUsername = user;
    dailymotionAccessToken = aToken;
    dailymotionRefreshToken = rToken;
    emit dailymotionAccountChanged(user, aToken, rToken, tokenExpiry);
}
