import QtQuick 1.0

Rectangle {
    id: appWindow

    property bool inPortrait: appWindow.height > appWindow.width

    /* Theme variables */

    property string _BACKGROUND_COLOR : Settings.appTheme == "light" ? "white" : "black"
    property string _TEXT_COLOR : Settings.appTheme == "light" ? "black" : "white"
    property int _SMALL_FONT_SIZE : 20
    property int _STANDARD_FONT_SIZE : 24
    property int _LARGE_FONT_SIZE : 40

    width: 800
    height: 480
    anchors.fill: parent
    color: _BACKGROUND_COLOR

    Image {
        id: background

        anchors.fill: appWindow
        source: appWindow.inPortrait ? "images/backgroundportrait.png" : "images/backgroundlandscape.png"
        smooth: true
        visible: Settings.appTheme != "light"
    }

    PageStack {
        id: pageStack

        initialPage: Qt.resolvedUrl("WidgetSettingsPage.qml")
    }

    TitleArea {
        id: titleArea
    }
}
