import QtQuick 1.0
import "components"
import "scripts/createobject.js" as ObjectCreator
import "scripts/youtube.js" as YT

Page {
    id: root

    property string subscriptionsFeed

    function setSubscriptionsFeed(feed) {
        subscriptionsFeed = feed;
        YT.getSubscriptions(subscriptionsFeed);
    }

    function goToUserProfile(user) {
        pageStack.push(Qt.resolvedUrl("YTUserPage.qml"));
        pageStack.currentPage.getUserProfile(user);
    }

    function goToNewSubVideos() {
        pageStack.push(Qt.resolvedUrl("YTListPage.qml"));
        pageStack.currentPage.topMargin = titleArea.height;
        pageStack.currentPage.setVideoFeed("http://gdata.youtube.com/feeds/api/users/" + profilePage.username + "/newsubscriptionvideos?v=2&alt=json&max-results=30");
        pageStack.currentPage.title = qsTr("New Subscription Videos");
    }

    title: qsTr("Subscriptions")
    tools: Menu {

        menuItems: MenuItem {
            text: qsTr("New subscription videos")
            onClicked: goToNewSubVideos()
        }
    }

    Connections {
        target: subscriptionsModel
        onLoadingChanged: {
            if ((!subscriptionsModel.loading) && (!subscriptionsModel.error) && (subscriptionsModel.count < subscriptionsModel.totalResults)) {
                YT.getSubscriptions(subscriptionsFeed);
            }
        }
    }

    ListView {
        id: subscriptionsList

        anchors.fill: parent
        boundsBehavior: Flickable.DragOverBounds
        clip: true
        model: ListModel {
            id: subscriptionsModel

            property bool loading : false
            property int totalResults
            property bool error: false
            property int page : 0
        }
        delegate: YTSubscriptionDelegate {
            id: delegate

            onClicked: goToUserProfile(title)
        }
        footer: Item {
            id: footer

            width: subscriptionsList.width
            height: 80
            visible: subscriptionsModel.loading
            opacity: footer.visible ? 1 : 0

            BusyDialog {
                anchors.centerIn: footer
                opacity: footer.opacity
            }
        }

        ScrollBar {}
    }

    Label {
        anchors.centerIn: subscriptionsList
        font.pixelSize: _LARGE_FONT_SIZE
        font.bold: true
        color: "#4d4d4d"
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        text: qsTr("No subscriptions found")
        visible: (!subscriptionsModel.loading) && (subscriptionsModel.count === 0)
    }
}
