import QtQuick 1.0
import "components"

Item {
    id: delegate

    property bool canBeClicked: true
    signal commentClicked(string author)

    width: delegate.ListView.view.width;
    height: authorText.height + commentText.height + 20

    Flow {
        id: authorText

        anchors { top: delegate.top; left: delegate.left; margins: 10 }
        width: parent.width
        height: 30

        Label {
            font.pixelSize: _SMALL_FONT_SIZE
            text: qsTr("By")
        }

        Label {
            font.pixelSize: _SMALL_FONT_SIZE
            color: (canBeClicked) && (author != YouTube.username) ? Settings.activeColor : _TEXT_COLOR
            text: " " + author + " "
            opacity: mouseArea.pressed ? 0.5 : 1
        }

        Label {
            font.pixelSize: _SMALL_FONT_SIZE
            text: qsTr("on") + " " + date.split("T")[0]
        }
    }

    MouseArea {
        id: mouseArea

        anchors.fill: authorText
        onClicked: commentClicked(author)
        enabled: canBeClicked
    }

    Label {
        id: commentText

        width: delegate.width - 20
        anchors {top: authorText.bottom; left: authorText.left }
        wrapMode: TextEdit.WordWrap
        font.pixelSize: _SMALL_FONT_SIZE
        color: "#4d4d4d"
        text: comment.replace(/\r/g, "")
    }
}
