import QtQuick 1.0
import "components"

Page {
    id: root

    title: qsTr("Settings") + " - " + qsTr("Appearance")

    Flickable {
        id: flicker

        anchors { fill: parent; topMargin: titleArea.height }
        contentWidth: parent.width
        contentHeight: col1.height
        flickableDirection: Flickable.VerticalFlick
        clip: true

        Column {
            id: col1

            anchors { top: parent.top; left: parent.left; right: parent.right; margins: 10 }
            spacing: 20

            Label {
                font.bold: true
                
                text: qsTr("Active color")
            }

            Flow {
                width: parent.width
                spacing: 10

                Repeater {
                    model: ["#66b907", "#418b11", "#37790c", "#346905", "#0fa9cd",
                        "#0881cb", "#066bbe", "#2054b1", "#6705bd", "#8d05bd",
                        "#cd0fbc", "#e805a3", "#ef5906", "#ea6910", "#f7751e",
                        "#ff8806", "#ed970c", "#f2b317", "#960000", "#ad0000",
                        "#cf0000", "#ea0000"]

                    Rectangle {
                        width: 50
                        height: 50
                        color: modelData
                        border.color: Settings.appTheme == "light" ? "#4d4d4d" : "white"
                        border.width: color == Settings.activeColor ? 2 : 0

                        MouseArea {
                            anchors.fill: parent
                            onClicked: {
                                Settings.activeColor = parent.color;
                                Settings.activeColorString = "color" + (index + 2).toString();
                            }
                        }
                    }
                }
            }
        }
    }
}
