import QtQuick 1.0
import "components"

Page {
    id: root

    property bool transfersDisplayed: true

    function selectAll() {
        var cl = transferList.checkList;
        for (var i = 0; i < transferList.count; i++) {
            cl.push(i);
        }
        transferList.checkList = cl;
    }

    function selectNone() {
        transferList.checkList = [];
    }

    function sortNumber(a, b) {
        /* Sort function for the checkList */

        return b - a;
    }

    function pauseTransfers() {
        for (var i = 0; i < transferList.checkList.length; i++) {
            transfers.pauseTransfer(transferList.checkList[i]);
        }
        transferList.checkList = [];
        transfers.getNextTransfer();
    }

    function resumeTransfers() {
        for (var i = 0; i < transferList.checkList.length; i++) {
            transfers.resumeTransfer(transferList.checkList[i]);
        }
        transferList.checkList = [];
        transfers.getNextTransfer();
    }

    function cancelTransfers() {
        var list = transferList.checkList;
        list.sort(sortNumber);
        for (var i = 0; i < list.length; i++) {
            transfers.cancelTransfer(list[i]);
        }
        transferList.checkList = [];
        transfers.getNextTransfer();
    }

    function openOrCloseMenu() {
        if (transferList.checkList.length === 0) {
            if (menu1.status == DialogStatus.Closed) {
                menu1.open();
            }
            else {
                menu1.close();
            }
        }
        else {
            if (menu2.status == DialogStatus.Closed) {
                menu2.open();
            }
            else {
                menu2.close();
            }
        }
    }

    title: qsTr("Transfers")
    tools: Menu {

        menuItems: [
            MenuItem {
                text: transferList.checkList.length === 0 ? qsTr("Select all") : qsTr("Select none")
                closeMenuWhenClicked: false
                onClicked: transferList.checkList.length === 0 ? selectAll() : selectNone();
            },

            MenuItem {
                text: qsTr("Pause")
                enabled: transferList.checkList.length > 0
                onClicked: pauseTransfers()
            },

            MenuItem {
                text: qsTr("Resume")
                enabled: transferList.checkList.length > 0
                onClicked: resumeTransfers()
            },

            MenuItem {
                text: qsTr("Cancel")
                enabled: transferList.checkList.length > 0
                onClicked: cancelTransfers()
            }
        ]
    }


    ListView {
        id: transferList

        property variant checkList : []

        function indexInCheckList(index) {
            var result = false;
            for (var i = 0; i < transferList.checkList.length; i ++) {
                if (transferList.checkList[i] == index) {
                    result = true;
                }
            }
            return result;
        }

        anchors { fill: parent; topMargin: titleArea.height }
        boundsBehavior: Flickable.DragOverBounds
        highlightRangeMode: ListView.StrictlyEnforceRange
        cacheBuffer: 2500
        clip: true
        model: transfers
        delegate: TransferListDelegate {
            id: delegate

            function addToOrRemoveFromCheckList() {
                var cl = transferList.checkList;
                if (!delegate.checked) {
                    cl.push(index);
                }
                else {
                    for (var i = 0; i < cl.length; i++) {
                        if (cl[i] == index) {
                            cl.splice(i, 1);
                        }
                    }
                }
                transferList.checkList = cl;
            }

            onClicked: addToOrRemoveFromCheckList()
            checked: transferList.indexInCheckList(index)
        }

        ScrollBar {}
    }

    Label {
        id: noResultsText

        anchors.centerIn: transferList
        font.pixelSize: _LARGE_FONT_SIZE
        font.bold: true
        color: "#4d4d4d"
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        text: qsTr("No transfers queued")
        visible: transferList.count == 0
    }
}
