import QtQuick 1.0

Item {
    id: button

    property bool useTheme : true
    property string iconSource
    property alias iconWidth: icon.width
    property alias iconHeight: icon.height
    property alias buttonState: background.state
    property bool enabled: true
    property bool checked: false
    property bool pressed: mouseArea.pressed

    signal clicked
    signal pressAndHold

    width: 50
    height: 50
    opacity: enabled ? 1 : 0.3

    Rectangle {
        id: background

        anchors.fill: button
        radius: 5
        gradient: Gradient {
            GradientStop { id: gradient1; position: 0.0; color: button.useTheme ? Settings.gradientColorHigh : "#524e4e" }
            GradientStop { id: gradient2; position: 0.7; color: button.useTheme ? Settings.gradientColor : "black"}
        }
        border.width: 2
        border.color: Settings.activeColor
        opacity: 0.7
        smooth: true
        state: (mouseArea.pressed) || (checked) ? "highlight" : ""

        states: State {
            name: "highlight"
            PropertyChanges { target: gradient1; color: Qt.lighter(Settings.activeColor, 1.2) }
            PropertyChanges { target: gradient2; color: Settings.activeColor }
        }
    }

    Image {
        id: icon

        anchors.centerIn: button
        width: 35
        height: 35
        source: iconSource == "" ? "" : "../" + iconSource
        sourceSize.width: icon.width
        sourceSize.height: icon.height
        smooth: true
    }

    MouseArea {
        id: mouseArea

        width: 60
        height: 60
        anchors.centerIn: button
        enabled: parent.enabled
        onClicked: parent.clicked()
        onPressAndHold: parent.pressAndHold()
    }
}



