import QtQuick 1.0

Item {
    id: delegate

    property bool canBeClicked: true

    signal commentClicked(string userId)

    width: !parent ? 0 : parent.width;
    height: authorText.height + commentText.height + 20

    Image {
        id: thumb

        width: 40
        height:40
        anchors { top: parent.top; left: parent.left; margins: 10 }
        source: !owner_avatar_medium_url ? "images/avatar.png" : owner_avatar_medium_url
        sourceSize.width: width
        sourceSize.height: height
        smooth: true
        opacity: mouseArea.pressed ? 0.5 : 1
        onStatusChanged: if (status == Image.Error) source = "images/avatar.png";

        MouseArea {
            id: mouseArea

            anchors.fill: parent
            enabled: canBeClicked
            onClicked: commentClicked(owner);
        }
    }

    Label {
        id: authorText

        height: 30
        anchors { top: thumb.top; left: thumb.right; leftMargin: 10; right: parent.right; rightMargin: 10 }
        font.pixelSize: _SMALL_FONT_SIZE
        
        elide: Text.ElideRight
        text: qsTr("By") + " " + owner_username

    }

    Label {
        id: commentText

        anchors { top: authorText.bottom; left: authorText.left; right: authorText.right }
        wrapMode: TextEdit.WordWrap
        font.pixelSize: _SMALL_FONT_SIZE
        color: "#4d4d4d"
        text: "\"" + message + "\""
    }
}
