#include "sharing.h"
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QUrl>
#include <QApplication>
#include <QClipboard>

#define EXCLUDED_CHARS " \n\t#[]{}=+$&*()<>@|',/\":;?"

Sharing::Sharing(QObject *parent) :
    QObject(parent), nam(0), facebookId("175388745824052"), twitterId("YmfKe14OCdVxn9FCL1S77A"), twitterSecret("evSW7txyhlvvPXkezKvJgaZ2lC97iXZc4ZLXLZxfsfc") {
    emit facebookIdChanged();
    emit twitterIdChanged();
    emit twitterSecretChanged();
}

void Sharing::setNetworkAccessManager(QNetworkAccessManager *manager) {
    nam = manager;
}

void Sharing::setFacebookAccessToken(const QString &token) {
    facebookToken = token;
    emit userSignedInToFacebookChanged();
}

void Sharing::setTwitterAccount(const QString &token, const QString &secret) {
    twitterToken = token;
    twitterTokenSecret = secret;
    emit userSignedInToTwitterChanged();
}

void Sharing::postToFacebook(const QString &site, const QString &videoId, const QString &title, const QString &description, const QString &message, const QString &thumb) {

    QByteArray id = videoId.toAscii();

    QByteArray playerUrl;
    QByteArray embedUrl;
    QByteArray thumbUrl = thumb.toAscii();
    if (site == "youtube") {
        playerUrl = "http://www.youtube.com/watch?v=" + id;
        embedUrl = "http://www.youtube.com/e/" + id;
    }
    else if (site == "dailymotion") {
        playerUrl = "http://www.dailymotion.com/video/" + id;
        embedUrl = "http://www.dailymotion.com/embed/video/" + id;
    }

    QByteArray postData = "access_token=" + facebookToken.toAscii()
            + "&message=" + message.toAscii().toPercentEncoding(EXCLUDED_CHARS)
            + "&link=" + playerUrl
            + "&source=" + embedUrl
            + "&picture=" + thumbUrl
            + "&name=" + title.toAscii().toPercentEncoding(EXCLUDED_CHARS)
            + "&description=" + description.toAscii().toPercentEncoding(EXCLUDED_CHARS);

    QNetworkRequest request(QUrl("https://graph.facebook.com/me/feed"));
    request.setHeader(QNetworkRequest::ContentTypeHeader, "application/x-www-form-urlencoded");
    QNetworkReply *reply = nam->post(request, postData);
    connect(reply, SIGNAL(finished()), this, SLOT(postFinished()));
    connect(this, SIGNAL(postSuccessful()), this, SIGNAL(postedToFacebook()));
}

void Sharing::postToTwitter(const QString &url, const QString &header, const QString &body) {
    QNetworkRequest request;
    request.setUrl(QUrl(url));
    request.setRawHeader("Authorization", header.toAscii());
    request.setHeader(QNetworkRequest::ContentTypeHeader, "application/x-www-form-urlencoded");
    QNetworkReply *reply = nam->post(request, body.toAscii());
    connect(reply, SIGNAL(finished()), this, SLOT(postFinished()));
    connect(this, SIGNAL(postSuccessful()), this, SIGNAL(postedToTwitter()));
}

void Sharing::postFinished() {
    QNetworkReply *reply = qobject_cast<QNetworkReply*>(sender());
    if (!reply) {
        return;
    }

    int statusCode = reply->attribute(QNetworkRequest::HttpStatusCodeAttribute).toInt();
    if ((statusCode == 200) || (statusCode == 201)) {
        emit postSuccessful();
    }
    QString statusText = reply->attribute(QNetworkRequest::HttpReasonPhraseAttribute).toString();
    emit alert(statusText);
    disconnect(this, SIGNAL(postSuccessful()), 0, 0);
    reply->deleteLater();
}

void Sharing::copyToClipboard(const QString &url) {
    QApplication::clipboard()->setText(url);
    emit alert(tr("Copied to clipboard"));
}

