import QtQuick 1.0

Dialog {
    id: root

    property alias model: listView.model
    property alias selectedIndex: listView.currentIndex
    property bool emitValueChosenSignal: true

    signal valueChosen(variant value)

    height: (listView.count > 5) || (!appWindow.inPortrait) ? appWindow.height - 100 : (listView.count * 80) + 60
    destroyOnClosing: false
    content: ListView {
        id: listView

        anchors.fill: parent
        clip: true
        currentIndex: -1
        delegate: SettingsDelegate {
            id: selectionDelegate

            onClicked: {
                listView.currentIndex = index;
                if (emitValueChosenSignal) {
                    valueChosen(value);
                }
                accept();
            }
        }

        ScrollBar {}
    }
}
