import QtQuick 1.0
import "components"
import "scripts/createobject.js" as ObjectCreator
import "scripts/youtube.js" as YT

Page {
    id: root

    function showNewPlaylistDialog() {
        var playlistDialog = ObjectCreator.createObject(Qt.resolvedUrl("NewPlaylistDialog.qml"), appWindow);
        playlistDialog.site = "youtube";
        playlistDialog.open();
    }

    function goToPlaylistVideos(playlist) {
        pageStack.push(Qt.resolvedUrl("YTPlaylistVideosPage.qml"));
        pageStack.currentPage.setPlaylist(playlist);
    }

    title: qsTr("My Playlists")
    tools: Menu {

        menuItems: MenuItem {
            text: qsTr("New playlist")
            onClicked: showNewPlaylistDialog()
        }
    }

    ContextMenu {
        id: contextMenu

        menuItems: [

            ContextMenuItem {
                text: qsTr("View")
                onClicked: goToPlaylistVideos(youtubePlaylistModel.get(playlists.selectedIndex))
            },

            ContextMenuItem {
                text: qsTr("Delete")
                onClicked: {
                    toggleBusy(true);
                    YouTube.deletePlaylist(youtubePlaylistModel.get(playlists.selectedIndex).playlistId);
                }
            }
        ]
    }

    ListView {
        id: playlists

        property int selectedIndex

        anchors.fill: parent
        boundsBehavior: Flickable.DragOverBounds
        highlightRangeMode: ListView.StrictlyEnforceRange
        clip: true
        model: youtubePlaylistModel
        delegate: YTPlaylistDelegate {
            id: delegate

            onClicked: goToPlaylistVideos(ObjectCreator.cloneObject(youtubePlaylistModel.get(index)))
            onPressAndHold: {
                playlists.selectedIndex = index;
                contextMenu.titleText = name;
                contextMenu.open();
            }
        }

        ScrollBar {}
    }

    Text {
        anchors.centerIn: playlists
        font.pixelSize: _LARGE_FONT_SIZE
        font.bold: true
        color: "#4d4d4d"
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        text: qsTr("No playlists found")
        visible: (!youtubePlaylistModel.loading) && (youtubePlaylistModel.count === 0)
    }
}
