import QtQuick 1.0
import QtWebKit 1.0
import "components"
import "scripts/OAuth.js" as OAuth

Dialog {
    id: root

    property string twitterToken
    property string twitterSecret
    property string twitterAuthUrl: "http://api.twitter.com/oauth/authorize?oauth_token="

    function checkUrlForToken() {
        var url = webView.url.toString();
        if (/oauth_verifier=/.test(url)) {
            var verifier = url.split("=")[2].split("&")[0];
            getTwitterAccessToken(verifier);
        }
        else if (/error/.test(url)) {
            messages.displayMessage(qsTr("Error obtaining twitter authorisation"));
        }
    }

    function getTwitterRequestToken() {
        busyDialog.show = true;
        var doc = new XMLHttpRequest();
        doc.onreadystatechange = function() {
            if (doc.readyState == XMLHttpRequest.DONE) {
                var response = doc.responseText;
                if (/oauth_token/i.test(response)) {
                    var tSplit = response.split('=');
                    twitterToken = tSplit[1].split('&')[0];
                    twitterSecret = tSplit[2].split('&')[0];
                    webView.url = twitterAuthUrl + twitterToken;
                }
                else {
                    messages.displayMessage(qsTr("Unable to obtain twitter request token"));
                }
                busyDialog.show = false;
            }
        }
        var credentials = { "callback": "http://www.cutetube.co.uk" };
        var oauthData = OAuth.createOAuthHeader("GET", "http://api.twitter.com/oauth/request_token", credentials);
        doc.open("GET", oauthData.url);
        doc.setRequestHeader("Authorization", oauthData.header);
        doc.send();
    }

    function getTwitterAccessToken(verifier) {
        busyDialog.show = true;
        var doc = new XMLHttpRequest();
        doc.onreadystatechange = function() {
            if (doc.readyState == XMLHttpRequest.DONE) {
                var response = doc.responseText;
                if (/oauth_token/i.test(response)) {
                    var tSplit = response.split('=');
                    var token = tSplit[2].split('&')[0];
                    var secret = tSplit[3].split('&')[0];
                    Settings.setTwitterAccount(token, secret);
                }
                else {
                    messages.displayMessage(qsTr("Unable to obtain twitter access token"));
                }
                busyDialog.show = false;
                accept();
            }
        }
        var credentials = { "token": twitterToken, "secret": twitterSecret, "verifier": verifier };
        var oauthData = OAuth.createOAuthHeader("GET", "http://api.twitter.com/oauth/access_token", credentials);
        doc.open("GET", oauthData.url);
        doc.setRequestHeader("Authorization", oauthData.header);
        doc.send();
    }

    Component.onCompleted: getTwitterRequestToken()

    titleText: qsTr("Twitter authorisation")
    content: Flickable {
        id: webFlicker

        anchors.fill: parent
        contentWidth: webView.width
        contentHeight: webView.height
        boundsBehavior: Flickable.DragOverBounds
        clip: true
        visible: webView.url != ""

        WebView {
            id: webView

            width: 1000
            height: 1000
            preferredWidth: parent.width
            preferredHeight: parent.height
            opacity:(status == WebView.Loading) || (webView.url.toString() == "") || (webView.url.toString().slice(0, 25) == "http://www.cutetube.co.uk") ? 0 : 1
            onUrlChanged: checkUrlForToken()

            Behavior on opacity { PropertyAnimation { properties: "opacity"; duration: 300 } }
        }
    }

    BusyDialog {
        id: busyDialog

        property bool show : false

        anchors.centerIn: parent
        visible: (busyDialog.show) || (webView.progress < 1)
    }
}
