import QtQuick 1.0

Item {
    id: banner

    property alias message : messageText.text

    height: 70

    Rectangle {
        id: background

        anchors.fill: banner
        color: Settings.activeColor
        smooth: true
        opacity: 0.8
    }

    Text {
        id: messageText


        anchors.fill: banner
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        wrapMode: Text.WordWrap
        font.pixelSize: _STANDARD_FONT_SIZE
        color: "white"
    }

    states: State {
        name: "portrait"
        PropertyChanges { target: banner; height: 105 }
    }
}
