import QtQuick 1.0

Loader {
    id: messages

    /* Message strings */

    property string _ADDED_TO_PLAYBACK_QUEUE: qsTr("Video(s) added to playback queue")
    property string _VIDEO_RATED: qsTr("Your rating has been added")
    property string _CANNOT_RATE: qsTr("You cannot rate your own videos")
    property string _COMMENT_ADDED: qsTr("Your comment has been added")
    property string _ADDED_TO_FAVOURITES: qsTr("Video(s) added to favourites")
    property string _DELETED_FROM_FAVOURITES: qsTr("Video(s) deleted from favourites")
    property string _VIDEO_IN_FAVOURITES: qsTr("Video already in favourites")
    property string _ADDED_TO_PLAYLIST: qsTr("Video(s) added to playlist")
    property string _PLAYLIST_CREATED: qsTr("New playlist created")
    property string _PLAYLIST_DELETED: qsTr("Playlist deleted")
    property string _VIDEO_METADATA_UPDATED: qsTr("Video metadata updated")
    property string _VIDEO_UPLOAD_ADDED: qsTr("Video added to upload queue")
    property string _VIDEO_DOWNLOAD_ADDED: qsTr("Videos(s) added to download queue")
    property string _NETWORK_ERROR: qsTr("Unable to establish a network connection")
    property string _FORMAT_ERROR: qsTr("Video format not suitable. Skipping")
    property string _PLAYBACK_ERROR: qsTr("Video cannot be played. Skipping")
    property string _SHARED_TO_FACEBOOK: qsTr("Video shared to facebook")
    property string _SHARED_TO_TWITTER: qsTr("Video shared to twitter")

    function displayMessage(message) {
        /* Display a notification using the message banner */

        if (!__videoPlaying) {
            messages.source = "";
            messages.source = Qt.resolvedUrl("InfoBannerComponent.qml");
            messages.item.message = message;
        }
        toggleBusy(false);
    }

    width: appWindow.width
    anchors.bottom: appWindow.top
    z: 1
    onLoaded: {
        messages.item.state = appWindow.state;
        timer.running = true;
        messages.state = "show"
    }

    Timer {
        id: timer

        interval: 2500
        onTriggered: messages.state = ""
    }

    states: State {
        name: "show"
        AnchorChanges { target: messages; anchors { bottom: undefined; top: appWindow.top } }
        PropertyChanges { target: messages; anchors.topMargin: 50 }
    }

    transitions: Transition {
        AnchorAnimation { easing.type: Easing.OutQuart; duration: 500 }
    }

}
