#ifndef DOWNLOADMANAGER_H
#define DOWNLOADMANAGER_H
#include <QObject>
#include <QtNetwork/QNetworkAccessManager>
#include <QUrl>
#include <QFile>
#include <QList>
#include <QTime>
#include <QVariantMap>
#include <QProcess>

class QNetworkAccessManager;
class QNetworkReply;
class QNetworkRequest;

class DownloadManager : public QObject {
    Q_OBJECT

    Q_PROPERTY(bool isDownloading
               READ isDownloading
               NOTIFY downloadingChanged)

public:
    explicit DownloadManager(QObject *parent = 0);

    void setNetworkAccessManager(QNetworkAccessManager *manager);
    bool isDownloading() const { return downloading; }

signals:

public slots:
    void setYouTubeDownloadQuality(const QString &quality);
    void setDownloadPath(const QString &path);
    void setXTubeDownloadPath(const QString &path);
    void startDownload(const QVariantMap &video);
    void pauseDownload();
    void cancelDownload();
    void deleteIncompleteDownload(const QVariantMap &video);

private slots:
    void parseYouTubeVideoPage(QNetworkReply *reply);
    void parseDailymotionVideoPage();
    void parseYouPornVideoPage();
    void parseXVideosVideoPage();
    void getYouTubeVideoUrl(const QString &videoId);
    void getDailymotionVideoUrl(const QString &videoId);
    void getYouPornVideoUrl(const QString &url);
    void getXVideosVideoUrl(const QString &url);
    void performDownload(const QUrl &videoUrl);
    void updateSize();
    void updateProgress(qint64 bytesReceived, qint64 bytesTotal);
    void downloadFinished();
    void downloadReadyRead();
    void setIsDownloading(const bool isDownloading) { downloading = isDownloading; emit downloadingChanged(); }
    void downloadThumbnail();
    void thumbnailDownloadFinished();
    void convertToAudio();
    void conversionFinished(int exitCode, QProcess::ExitStatus exitStatus);

private:
    QNetworkAccessManager *nam;
    int downloadFormat;
    QHash<QString, int> dlMap;
    QFile output;
    bool downloading;
    QNetworkReply *downloadReply;
    QTime downloadTime;
    QString downloadPath;
    QString xtubeDownloadPath;
    QVariantMap videoToDownload;
    QProcess *converter;

signals:
    void alert(const QString &message);
    void gotVideoUrl(const QUrl &videoUrl);
    void downloadCompleted();
    void downloadStarted();
    void downloadCancelled();
    void downloadPaused();
    void downloadResumed();
    void downloadFailed(const QString &reason);
    void statusChanged(const QString &status);
    void progressChanged(float progress, int eta);
    void sizeChanged(qint64 size);
    void downloadingChanged();
    void conversionStarted();
};

#endif // DOWNLOADMANAGER_H
