#ifndef DBUSSERVICE_H
#define DBUSSERVICE_H

#include <QObject>

class DBusService : public QObject {
    Q_OBJECT
public:
    explicit DBusService(QObject *parent = 0);

public Q_SLOTS:
    void play(const QString &url);
    void display(const QString &url);

private:
    void parseUrl(const QString &url, const QString &action);

signals:
    void playYouTubeVideo(const QString &videoId);
    void displayYouTubeVideo(const QString &videoId);
    void playDailymotionVideo(const QString &videoId);
    void displayDailymotionVideo(const QString &videoId);
};

#endif // DBUSSERVICE_H
