import QtQuick 1.0

Item {

    property alias title: title.text
    property alias subTitle: subTitle.text

    signal clicked

    width: parent.width
    height: 80

    ListHighlight {
        visible: mouseArea.pressed
    }

    Column {

        anchors { left: parent.left; leftMargin: 10; right: icon.left; rightMargin: 10; verticalCenter: parent.verticalCenter }

        Text {
            id: title

            font.bold: true
            color: _TEXT_COLOR
            font.pixelSize: _STANDARD_FONT_SIZE
            verticalAlignment: Text.AlignVCenter
        }

        Text {
            id: subTitle

            width: parent.width
            color: "#4d4d4d"
            verticalAlignment: Text.AlignVCenter
            elide: Text.ElideRight
        }
    }

    Image {
        id: icon

        anchors { right: parent.right; rightMargin: 20; verticalCenter: parent.verticalCenter }
        source: Settings.appTheme == "light" ? "../images/icon-m-common-combobox-arrow.png" : "../images/icon-m-textinput-combobox-arrow.png"
    }

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        onClicked: parent.clicked()
    }
}
