import QtQuick 1.0

Row {

    property int count
    property double ratingValue
    property int maximumValue

    spacing: 5

    Repeater {
        id: repeater

        model: maximumValue

        Image {
            width: 20
            height: 20
            source: (ratingValue < 1) || (index > ratingValue) ? Settings.appTheme == "light" ? "../images/favourite.png" : "../images/favourite-white.png" : "../images/favourite-" + Settings.activeColorString + ".png"
            smooth: true
        }
    }

    Text {
        font.pixelSize: _SMALL_FONT_SIZE
        color: _TEXT_COLOR
        text: "(" + count + ")"
        visible: count > 0
    }
}
