import QtQuick 1.0

Item {
    id: root

    property int buttonWidth: 150
    property alias buttons: buttonRow.children
    property bool enabled: true

    width: buttonRow.children.length * buttonWidth
    height: 50

    Rectangle {
        anchors.fill: parent
        radius: 10
        gradient: Gradient {
            GradientStop { id: gradient1; position: 0.0; color: Settings.gradientColorHigh }
            GradientStop { id: gradient2; position: 0.7; color: Settings.gradientColor }
        }
        border.width: 2
        border.color: Settings.activeColor
        opacity: 0.7
        smooth: true
        states: State {
            name: "highlight"
            PropertyChanges { target: gradient1; color: Qt.lighter(Settings.activeColor, 1.2) }
            PropertyChanges { target: gradient2; color: Settings.activeColor }
        }
    }

    Row {
        id: buttonRow

        anchors.fill: root
    }

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        enabled: false
    }

    states: State {
        name: "disabled"
        when: !enabled
        PropertyChanges { target: root; opacity: 0.3 }
        PropertyChanges { target: mouseArea; enabled: true }
    }
}


