import QtQuick 1.0

Item {
    id: button

    property bool disabled : false
    property int buttonCount
    property bool showIcons : false
    property bool showLabels : !button.showIcons
    property int currentButton : -1

    signal clicked(int index)

    function setButtons(data, toShowIcons) {
        /* Set the number of buttons and the icons/labels */

        button.buttonCount = data.length;
        if (toShowIcons) {
            button.showIcons = true;
            for (var i = 0; i < data.length; i++) {
                buttonRow.children[i].children[0].source = data[i];
            }
        }
        else {
            for (var i = 0; i < data.length; i++) {
                buttonRow.children[i].children[1].text = data[i];
            }
        }
    }

    height: button.buttonCount * 50

    Rectangle {
        anchors.fill: parent
        radius: 10
        gradient: Gradient {
            GradientStop { id: gradient1; position: 0.0; color: Settings.gradientColorHigh }
            GradientStop { id: gradient2; position: 0.7; color: Settings.gradientColor }
        }
        border.width: 2
        border.color: Settings.activeColor
        opacity: 0.7
        smooth: true
        states: State {
            name: "highlight"
            PropertyChanges { target: gradient1; color: Qt.lighter(Settings.activeColor, 1.2) }
            PropertyChanges { target: gradient2; color: Settings.activeColor }
        }
    }

    Column {
        id: buttonRow

        anchors.fill: button

        Repeater {
            id: repeater

            model: button.buttonCount

            Item {
                width: Math.floor(button.width / button.buttonCount)
                height: button.height

                Image {
                    anchors.centerIn: parent
                    width: 50
                    height: 50
                    smooth: true
                    sourceSize.width: width
                    sourceSize.height: height
                    visible: button.showIcons
                }

                Text {
                    property int textSize : 24

                    anchors { fill: parent; margins: 2 }
                    font.pixelSize: textSize
                    elide: Text.ElideRight
                    horizontalAlignment: Text.AlignHCenter
                    verticalAlignment: Text.AlignVCenter
                    color: (button.currentButton == index) ? Settings.activeColor : _TEXT_COLOR
                    visible: button.showLabels
                    smooth: true
                }

                Rectangle {
                    width: 1
                    height: parent.height - 20
                    anchors { right: parent.right; verticalCenter: parent.verticalCenter }
                    color: Settings.activeColor
                    opacity: 0.7
                    visible: (index < button.buttonCount - 1)
                }

                MouseArea {
                    id: mouseArea

                    anchors.fill: parent
                    onClicked: {
                        button.currentButton = index;
                        button.clicked(index);
                    }
                }
            }
        }
    }

    states: State {
        name: "disabled"
        when: button.disabled
        PropertyChanges { target: button; opacity: 0.3 }
        PropertyChanges { target: mouseArea; enabled: false }
    }
}


