import QtQuick 1.0
import "components"

Item {
    id: delegate

    signal clicked
    signal pressAndHold

    width: parent.width
    height: 80

    ListHighlight {
        visible: mouseArea.pressed
    }

    Text {
        id: titleText

        anchors { left: parent.left; leftMargin: countBubble.width + 20; verticalCenter: parent.verticalCenter; right: countBubble.left; rightMargin: 10 }
        elide: Text.ElideRight
        text: name
        color: _TEXT_COLOR
        font.bold: true
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
    }

    CountBubble {
        id: countBubble

        width: 40
        anchors { right: parent.right; rightMargin: 10; verticalCenter: parent.verticalCenter }
        value: videoCount
    }

    MouseArea {
        id: mouseArea

        anchors.fill: delegate
        onClicked: parent.clicked()
        onPressAndHold: parent.pressAndHold()
    }
}
