#ifndef DATABASE_H
#define DATABASE_H

#include <QObject>
#include <QStringList>
#include <QVariantMap>
#include <QtSql/QSqlDatabase>

class QNetworkAccessManager;
class QNetworkReply;

class Database : public QObject {
    Q_OBJECT

public:
    explicit Database(QObject *parent = 0);
    virtual ~Database();

public slots:
    void initialize();
    bool storeDownload(const QVariantMap &video);
    bool removeStoredDownload(const QString &videoId);
    QVariantList getStoredDownloads();
    void deleteArchiveVideos(const QStringList &videos);

signals:
    void alert(const QString &message);
    void archiveVideosDeleted();

private:
    QSqlDatabase database;
};

#endif // DATABASE_H
