import QtQuick 1.0

Item {

    property alias icon: button.icon
    property alias label: label.text

    signal buttonClicked

    PushButton {
        id: button

        width: 100
        height: 100
        anchors { left: parent.left; verticalCenter: parent.verticalCenter; leftMargin: 10 }
        iconWidth: 100
        iconHeight: 100
        isPressed: mouseArea.pressed
    }

    Text {
        id: label

        anchors { left: button.right; verticalCenter: parent.verticalCenter; right: parent.right; rightMargin: 10 }
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        elide: Text.ElideRight
        font.pixelSize: _LARGE_FONT_SIZE
        color: mouseArea.pressed ? _ACTIVE_COLOR_LOW : _TEXT_COLOR
    }

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        onClicked: buttonClicked()
    }
}
