import Qt 4.7

Item {

    id: button

    width: parent.width / 6
    height: parent.height

    property alias name : title.text
    property alias icon : icon.source
    property alias showIcon : icon.visible
    property alias showText : title.visible
    property alias showSeparator : separator.visible

    signal buttonClicked
    signal buttonPressed

//    Rectangle {
//        id: background

//        anchors.fill: button
//        gradient: Gradient {
//            GradientStop { position: 0.0; color: _ACTIVE_COLOR_HIGH }
//            GradientStop { position: 0.7; color: _ACTIVE_COLOR_LOW }
//        }
//        smooth: true
//        opacity: mouseArea.pressed ? 1 : 0.7
//    }

    Text {
        id: title

        anchors.centerIn: button
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        font.pixelSize: _STANDARD_FONT_SIZE
        font.bold: true
        color: "white"
        smooth: true
        visible: false
    }

    Image {
        id: background

        width: 50
        height: 50
        anchors.centerIn: button
        source: "ui-images/menubuttonbackground.png"
        sourceSize.width: background.width
        sourceSize.height: background.height
        smooth: true
        visible: mouseArea.pressed
    }

    Image {
        id: icon

        width: 50
        height: 50
        anchors.centerIn: button
        sourceSize.width: icon.width
        sourceSize.height: icon.height
        smooth: true
        opacity: 0.5
//        visible: false
    }

    Rectangle {
        id: separator
        width: 1
        height: 40
        anchors { left: button.left; verticalCenter: button.verticalCenter }
        color: _TEXT_COLOR
        opacity: 0.5
        visible: false
    }

    MouseArea {
        id: mouseArea

        anchors.fill: button
        onClicked: buttonClicked()
        onPressAndHold: buttonPressed()
    }
}




