import Qt 4.7

Item {
    id: menu

    property string currentSource : (menu.parent.currentIndex == 0) ? "HomeView" : menu.parent.currentItem.source

    property variant buttonOneIcons
    property variant buttonTwoIcons
    property variant buttonThreeIcons
    property variant buttonFourIcons
    property variant buttonFiveIcons

    signal backClicked
    signal homeClicked
    signal quitClicked

    width: parent.width
    height: 60
    anchors.bottom: parent.bottom
    z: 3

    Component.onCompleted: {
        buttonOneIcons = {
                "HomeView": "settingsicon", "MyAccountView": "uploadsicon", "VideoListView": "favouritesicon",
                "UserVideosView": "favouritesicon", "PlaylistVideosView": "favouritesicon",
                "PlaylistsView": "playlistsicon", "SubscriptionsView": "subscriptionsicon",
                "ArchiveListView": "deletearchiveicon", "VideoInfoView": "favouritesicon"
    };

        buttonTwoIcons = {
                "HomeView": "accountsicon", "VideoListView": "playlistsicon",
                "UserVideosView": "playlistsicon", "PlaylistVideosView": "deleteplaylistsicon",
                "ArchiveListView": "deletediskicon", "VideoInfoView": "playlistsicon"
    };

        buttonThreeIcons = {
                "HomeView": "abouticon", "VideoListView": "videodownloadicon",
                "UserVideosView": "videodownloadicon", "PlaylistVideosView": "videodownloadicon",
                "ArchiveListView": "mostrecenticon", "VideoInfoView": "facebookicon"
    };

        buttonFourIcons = {
                "VideoListView": "audiodownloadicon",
                "UserVideosView": "audiodownloadicon", "PlaylistVideosView": "audiodownloadicon",
                "ArchiveListView": "sorttitleicon", "VideoInfoView": "clipboardicon"
    };

        buttonFiveIcons = {
                "VideoListView": "clipboardicon",
                "UserVideosView": "clipboardicon", "PlaylistVideosView": "clipboardicon"
    };

    }


    Image {
        id: menuImage

        anchors.fill: menu
        source: "ui-images/menu2.png"
        sourceSize.width: menuImage.width
        sourceSize.height: menuImage.height
        fillMode: Image.PreserveAspectCrop
        smooth: true
    }

    Row {
        anchors.fill: menu

        MenuButton {
            id: buttonOne

            showSeparator: false
            visible: menu.buttonOneIcons[menu.currentSource.split("/").pop().split(".")[0]] != undefined
            icon: {
                if (buttonOne.visible) {
                    if ((menu.parent.currentIndex > 0) && (menu.parent.currentItem.item.videoFeed == _FAVOURITES_FEED)) {
                        "ui-images/deletefavouritesicon.png";
                    }
                    else {
                        "ui-images/" + menu.buttonOneIcons[menu.currentSource.split("/").pop().split(".")[0]] + ".png";
                    }
                }
                else {
                    "";
                }
            }
            onButtonClicked: (menu.parent.currentIndex == 0) ? menu.parent.currentItem.onMenuButtonOneClicked() : menu.parent.currentItem.item.onMenuButtonOneClicked()
        }

        MenuButton {
            id: buttonTwo

            visible: menu.buttonTwoIcons[menu.currentSource.split("/").pop().split(".")[0]] != undefined
            icon: buttonTwo.visible ? "ui-images/" + menu.buttonTwoIcons[menu.currentSource.split("/").pop().split(".")[0]] + ".png" : ""
            onButtonClicked: (menu.parent.currentIndex == 0) ? menu.parent.currentItem.onMenuButtonTwoClicked() : menu.parent.currentItem.item.onMenuButtonTwoClicked()
        }

        MenuButton {
            id: buttonThree

            visible: menu.buttonThreeIcons[menu.currentSource.split("/").pop().split(".")[0]] != undefined
            icon: buttonThree.visible ? "ui-images/" + menu.buttonThreeIcons[menu.currentSource.split("/").pop().split(".")[0]] + ".png" : ""
            onButtonClicked: (menu.parent.currentIndex == 0) ? menu.parent.currentItem.onMenuButtonThreeClicked() : menu.parent.currentItem.item.onMenuButtonThreeClicked()
        }

        MenuButton {
            id: buttonFour

            visible: menu.buttonFourIcons[menu.currentSource.split("/").pop().split(".")[0]] != undefined
            icon: buttonFour.visible ? "ui-images/" + menu.buttonFourIcons[menu.currentSource.split("/").pop().split(".")[0]] + ".png" : ""
            onButtonClicked: menu.parent.currentItem.item.onMenuButtonFourClicked()
        }

        MenuButton {
            id: buttonFive

            visible: menu.buttonFiveIcons[menu.currentSource.split("/").pop().split(".")[0]] != undefined
            icon: buttonFive.visible ? "ui-images/" + menu.buttonFiveIcons[menu.currentSource.split("/").pop().split(".")[0]] + ".png" : ""
            onButtonClicked: menu.parent.currentItem.item.onMenuButtonFiveClicked()
        }
    }

    Text {
        anchors { top: menu.top; horizontalCenter: menu.horizontalCenter }
        font.pixelSize: 14
        horizontalAlignment: Text.AlignHCenter
        color: "white"
        text: "Sort"
        smooth: true
        opacity: (menu.currentSource.split("/").pop().split(".")[0] == "ArchiveListView") ? 0.5 : 0
    }

    MenuButton {
        id: backButton

        anchors.right: menu.right
        icon: "ui-images/backicon.png"
        onButtonClicked: backClicked()
        onButtonPressed: homeClicked()
        visible: !quitButton.visible
    }

    MenuButton {
        id: quitButton

        anchors.right: menu.right
        icon: "ui-images/quiticon.png"
        visible: menu.parent.currentIndex == 0
        onButtonClicked: quitClicked()
    }

    MouseArea {
        z: -1
        anchors.fill: menu
    }
}


