import Qt 4.7
import "scripts/createobject.js" as ObjectCreator

Rectangle {
    id: window

    property alias dimmerState : dimmer.state

    signal myChannel
    signal mostRecent
    signal mostViewed
    signal archive
    signal dialogClose

    function showNoAccountDialog() {
        if (dimmer.state == "") {
            toggleControls(false);
            var noAccDialog = ObjectCreator.createObject("NoAccountDialog.qml", window);
            noAccDialog.close.connect(closeDialogs);
            dimmer.state = "dim";
            noAccDialog.state = "show";
            mouseArea.enabled = true;
        }
    }

    function onMenuButtonOneClicked() {
        /* Show the settings dialog */

        if (dimmer.state == "") {
            toggleControls(false);
            var settingsDialog = ObjectCreator.createObject("SettingsDialog.qml", window);
            settingsDialog.close.connect(closeDialogs);
            dimmer.state = "dim";
            settingsDialog.state = "show";
            mouseArea.enabled = true;
        }
    }

    function onMenuButtonTwoClicked() {
        /* Show the accounts dialog */

        if (dimmer.state == "") {
            toggleControls(false);
            var accDialog = ObjectCreator.createObject("AccountsDialog.qml", window);
            accDialog.close.connect(closeDialogs);
            dimmer.state = "dim";
            accDialog.state = "show";
            mouseArea.enabled = true;
        }
    }

    function onMenuButtonThreeClicked() {
        /* Show the 'about' dialog */

        if (dimmer.state == "") {
            toggleControls(false);
            var aboutDialog = ObjectCreator.createObject("AboutDialog.qml", window);
            aboutDialog.close.connect(closeDialogs);
            dimmer.state = "dim";
            aboutDialog.state = "show";
            mouseArea.enabled = true;
        }
    }

    function showConfirmExitDialog() {
        /* If a download is taking place, show
          a confirmation dialog */

        toggleControls(false);
        var confirmDialog = ObjectCreator.createObject("ConfirmExitDialog.qml", window);
        confirmDialog.close.connect(closeDialogs);
        dimmer.state = "dim";
        confirmDialog.state = "show";
        mouseArea.enabled = true;
    }

    function closeDialogs() {
        /* Close any open dialogs and return the window to its default state */

        dialogClose();
        dimmer.state = "";
        mouseArea.enabled = false;
        toggleControls(true);
    }

    color: _BACKGROUND_COLOR

    Rectangle {
        id: dimmer

        anchors.fill: window
        color: window.color

        Grid {
            id: buttonGrid

            anchors.centerIn: dimmer
            rows: 2
            columns: 4
            spacing: (window.state == "") ? Math.floor(window.width / 12) : Math.floor(window.height / 12)

            Column {

                PushButton {
                    id: myAccountButton

                    width: (window.state == "") ? (window.width / 6) : (window.height / 6)
                    height: myAccountButton.width
                    smooth: true
                    icon: (cuteTubeTheme == "light") ? "ui-images/myaccounticonlight.png" : "ui-images/myaccounticon.png"
                    iconWidth: 100
                    iconHeight: 100
                    onButtonClicked: myChannel()
                }

                Text {
                    y: 10
                    width: myAccountButton.width
                    text: qsTr("My Channel")
                    font.pixelSize: _SMALL_FONT_SIZE
                    color: _TEXT_COLOR
                    horizontalAlignment: Text.AlignHCenter
                }
            }

            Column {

                PushButton {
                    id: mostRecentButton

                    width: myAccountButton.width
                    height: myAccountButton.height
                    smooth: true
                    icon: (cuteTubeTheme == "light") ? "ui-images/mostrecenticonlight.png" : "ui-images/mostrecenticon.png"
                    iconWidth: 100
                    iconHeight: 100
                    onButtonClicked: mostRecent()
                }

                Text {
                    y: 10
                    width: mostRecentButton.width
                    text: qsTr("Most Recent")
                    font.pixelSize: _SMALL_FONT_SIZE
                    color: _TEXT_COLOR
                    horizontalAlignment: Text.AlignHCenter
                }
            }

            Column {

                PushButton {
                    id: mostViewedButton

                    width: myAccountButton.width
                    height: myAccountButton.height
                    smooth: true
                    icon: (cuteTubeTheme == "light") ? "ui-images/mostviewediconlight.png" : "ui-images/mostviewedicon.png"
                    iconWidth: 100
                    iconHeight: 100
                    onButtonClicked: mostViewed()
                }

                Text {
                    y: 10
                    width: mostViewedButton.width
                    text: qsTr("Most Viewed")
                    font.pixelSize: _SMALL_FONT_SIZE
                    color: _TEXT_COLOR
                    horizontalAlignment: Text.AlignHCenter
                }
            }

            Column {

                PushButton {
                    id: archiveButton

                    width: myAccountButton.width
                    height: myAccountButton.height
                    smooth: true
                    icon: (cuteTubeTheme == "light") ? "ui-images/downloadiconlight.png" : "ui-images/downloadicon.png"
                    iconWidth: 100
                    iconHeight: 100
                    onButtonClicked: archive()
                }

                Text {
                    y: 10
                    width: archiveButton.width
                    text: qsTr("Archive")
                    font.pixelSize: _SMALL_FONT_SIZE
                    color: _TEXT_COLOR
                    horizontalAlignment: Text.AlignHCenter
                }
            }
        }

        MouseArea {
            id: mouseArea

            anchors.fill: dimmer
            enabled: false
            onClicked: closeDialogs()
        }

        states: State {
            name: "dim"
            PropertyChanges { target: dimmer; opacity: 0.3 }
        }

        transitions: Transition {
            PropertyAnimation { target: dimmer; properties: "opacity"; duration: 500 }
        }
    }

    states: State {
        name: "portrait"
        when: window.height > window.width
        PropertyChanges { target: buttonGrid; columns: 2 }
    }
}
