import Qt 4.7
import "scripts/settings.js" as Settings

Item {
    id: dialog

    property string playbackQuality
    property string downloadQuality
    property string downloadStatus
    property string downloadPath
    property string safeSearch
    property string screenOrientation
    property string mediaPlayer
    property string theme
    property string language
    property string proxy
    property string widgetFeedOne
    property string widgetFeedTwo
    property string widgetFeedThree
    property string widgetFeedFour

    property variant playbackSettings
    property variant downloadSettings
    property variant downloadStatusSettings
    property variant safeSearchSettings
    property variant orientationSettings
    property variant mediaPlayerSettings
    property variant themeSettings
    property variant languageSettings
    property variant widgetFeeds

    property string settingToBeChanged

    signal close

    Component.onCompleted: {
        playbackSettings = { "mobile": qsTr("Mobile"), "hq": qsTr("High quality") };
        downloadSettings = { "mobile": qsTr("Mobile"), "hq": qsTr("High quality"), "360p": qsTr("360p"), "480p": qsTr("480p"), "720p": qsTr("720p") };
        downloadStatusSettings = { "queued": qsTr("Automatically"), "paused": qsTr("Manually") };
        safeSearchSettings = { "strict": qsTr("On"), "none": qsTr("Off") };
        orientationSettings = { "automatic": qsTr("Automatic"), "landscape": qsTr("Landscape"), "portrait": qsTr("Portrait") };
        themeSettings = { "light": qsTr("Light"), "dark": qsTr("Dark") };
        languageSettings = { "nl": qsTr("Dutch"), "en": qsTr("English"), "fi": qsTr("Finnish"), "de": qsTr("German"), "it": qsTr("Italian"), "pl": qsTr("Polish"), "ru": qsTr("Russian") };
        widgetFeeds = { "_MOST_RECENT_FEED": qsTr("Most recent"), "_MOST_VIEWED_FEED": qsTr("Most viewed"),
                "archive": qsTr("Archive"), "_NEW_SUB_VIDEOS_FEED": qsTr("Latest subscription videos"),
                "_UPLOADS_FEED": qsTr("My uploads"), "_FAVOURITES_FEED": qsTr("My favourites") };

        getSettings();
    }

    function getSettings() {
        /* Retrieve relevent settings from the database
          and populate the dialog */

        widgetSettings.visible = Controller.widgetInstalled();
        mediaPlayerSettings = Controller.getInstalledMediaPlayers();
        playbackQuality = playbackSettings[Settings.getSetting("playbackQuality")];
        downloadQuality = downloadSettings[Settings.getSetting("downloadQuality")];
        downloadStatus = downloadStatusSettings[Settings.getSetting("downloadStatus")];
        safeSearch = safeSearchSettings[Settings.getSetting("safeSearch")];
        downloadPath = Settings.getSetting("downloadPath");
        screenOrientation = orientationSettings[Settings.getSetting("screenOrientation")];
        mediaPlayer = Settings.getSetting("mediaPlayer");
        theme = themeSettings[Settings.getSetting("theme")];
        language = languageSettings[Settings.getSetting("language")];
        proxy = Settings.getSetting("proxy");
        widgetFeedOne = widgetFeeds[Settings.getSetting("widgetFeedOne")];
        widgetFeedTwo = widgetFeeds[Settings.getSetting("widgetFeedTwo")];
        widgetFeedThree = widgetFeeds[Settings.getSetting("widgetFeedThree")];
        widgetFeedFour = widgetFeeds[Settings.getSetting("widgetFeedFour")];
    }

    function saveSettings() {
        /* Save all settings to the database */

        var settings = [ ["playbackSettings", "playbackQuality"],
                        ["downloadSettings", "downloadQuality"],
                        ["downloadStatusSettings", "downloadStatus"],
                        ["safeSearchSettings", "safeSearch"],
                        ["orientationSettings", "screenOrientation"],
                        ["themeSettings", "theme"],
                        ["languageSettings", "language"],
                        ["widgetFeeds", "widgetFeedOne"],
                        ["widgetFeeds", "widgetFeedTwo"],
                        ["widgetFeeds", "widgetFeedThree"],
                        ["widgetFeeds", "widgetFeedFour"] ];

        var settingDict;
        var value;
        for (var i = 0; i < settings.length; i++) {
            settingDict = eval(settings[i][0]);
            value = eval(settings[i][1]);
            for (var attribute in settingDict) {
                if (settingDict[attribute] == value) {
                    Settings.setSetting(settings[i][1], attribute);
                }
            }
        }
        Settings.setSetting("proxy", proxy);
        Settings.setSetting("mediaPlayer", mediaPlayer);
        Settings.setSetting("downloadPath", downloadPath);
        cuteTubeTheme = Settings.getSetting("theme");
        Controller.setOrientation(Settings.getSetting("screenOrientation"));
        Controller.setMediaPlayer(mediaPlayer)
        displayMessage(qsTr("Your settings have been saved"));
        close();
    }

    function showDownloadPathDialog() {
        settingToBeChanged = qsTr("Download Path");
        settingsLoader.source = "FileChooserDialog.qml";
        settingsLoader.item.title = qsTr("Download Location");
        settingsLoader.item.showButton = true;
        settingsLoader.item.showFiles = false;
        settingsLoader.item.folder = downloadPath;
        dialog.state = "showChild";
    }

    function showProxyDialog() {
        settingToBeChanged = qsTr("Network Proxy");
        settingsLoader.source = "ProxyDialog.qml";
        settingsLoader.item.setProxy(proxy);
        dialog.state = "showChild";
    }

    function showSettingsList(title, settingsList, currentSetting) {
        /* Show the settings list dialog */

        var list = [];
        var settings = eval(settingsList);
        for (var value in settings) {
            list.push(settings[value]);
        }
        list.sort();
        settingToBeChanged = title;
        settingsLoader.source = "SettingsListDialog.qml";
        settingsLoader.item.setSettingsList(title, list, currentSetting);
        dialog.state = "showChild";
    }

    function changeSetting(setting) {
        /* Change the appropriate setting in the dialog */

        if (settingToBeChanged == qsTr("Playback Quality")) {
            playbackQuality = setting;
        }
        else if (settingToBeChanged == qsTr("Download Quality")) {
            downloadQuality = setting;
        }
        else if (settingToBeChanged == qsTr("Start Downloads")) {
            downloadStatus = setting;
        }
        else if (settingToBeChanged == qsTr("Download Path")) {
            downloadPath = setting;
        }
        else if (settingToBeChanged == qsTr("Safe Search")) {
            safeSearch = setting;
        }
        else if (settingToBeChanged == qsTr("Screen Orientation")) {
            screenOrientation = setting;
        }
        else if (settingToBeChanged == qsTr("Media Player")) {
            mediaPlayer = setting;
        }
        else if (settingToBeChanged == qsTr("Theme")) {
            theme = setting;
        }
        else if (settingToBeChanged == qsTr("Language")) {
            language = setting;
        }
        else if (settingToBeChanged == qsTr("Network Proxy")) {
            proxy = setting;
        }
        else if (settingToBeChanged == qsTr("Widget Feed One")) {
            widgetFeedOne = setting;
        }
        else if (settingToBeChanged == qsTr("Widget Feed Two")) {
            widgetFeedTwo = setting;
        }
        else if (settingToBeChanged == qsTr("Widget Feed Three")) {
            widgetFeedThree = setting;
        }
        else if (settingToBeChanged == qsTr("Widget Feed Four")) {
            widgetFeedFour = setting;
        }
    }

    function clearSearches() {
        /* Delete all saved searches from the database */

        if (Settings.clearSearches() == "OK") {
            displayMessage(qsTr("Your saved searches have been cleared"));
        }
        else {
            displayMessage(qsTr("Database error. Unable to clear searches"));
        }
    }

    width: parent.width
    anchors { right: parent.left; top: parent.top; bottom: parent.bottom }

    Connections {
        target: dialog.parent

        onDialogClose: {
            dialog.state = "";
            dialog.destroy(600);
        }
    }

    Loader {
        id: settingsLoader

        width: parent.width
        anchors { right: parent.left; top: parent.top; bottom: parent.bottom }

        Connections {
            target: settingsLoader.item
            onClose: dialog.state = "show"
            onSettingChosen: changeSetting(setting)
        }
    }

    Item {
        id: background

        anchors.fill: dialog

        Rectangle {
            anchors.fill: background
            color: _BACKGROUND_COLOR
            opacity: 0.5
            smooth: true
        }

        Text {
            id: title

            anchors { horizontalCenter: background.horizontalCenter; top: background.top; topMargin: 10 }
            font.pixelSize: _SMALL_FONT_SIZE
            color: _TEXT_COLOR
            text: qsTr("Settings")
            smooth: true
        }

        Flickable {
            id: flicker

            anchors { fill: background; topMargin: 50; leftMargin: 10; rightMargin: 10; bottomMargin: (dialog.parent.state == "") ? 90 : 160 }
            contentWidth: dialog.width
            contentHeight: divider.height + widgetDivider.height + 80
            clip: true
            flickableDirection: Flickable.VerticalFlick
            boundsBehavior: Flickable.DragOverBounds

            Rectangle {
                id: divider

                width: 1
                height: settingColumn.height
                anchors { top: parent.top; horizontalCenter: parent.horizontalCenter }
                color: _ACTIVE_COLOR_LOW


                Column {
                    id: settingColumn

                    anchors { right: divider.left; rightMargin: 10; top: divider.top }
                    spacing: 10

                    Text {
                        font.pixelSize: _STANDARD_FONT_SIZE
                        color: _TEXT_COLOR
                        horizontalAlignment: Text.AlignRight
                        text: qsTr("Network proxy")
                        smooth: true
                    }

                    Text {
                        font.pixelSize: _STANDARD_FONT_SIZE
                        color: _TEXT_COLOR
                        horizontalAlignment: Text.AlignRight
                        text: qsTr("Playback quality")
                        smooth: true
                    }

                    Text {
                        font.pixelSize: _STANDARD_FONT_SIZE
                        color: _TEXT_COLOR
                        horizontalAlignment: Text.AlignRight
                        text: qsTr("Download quality")
                        smooth: true
                    }

                    Text {
                        font.pixelSize: _STANDARD_FONT_SIZE
                        color: _TEXT_COLOR
                        horizontalAlignment: Text.AlignRight
                        text: qsTr("Start downloads")
                        smooth: true
                    }

                    Text {
                        font.pixelSize: _STANDARD_FONT_SIZE
                        color: _TEXT_COLOR
                        horizontalAlignment: Text.AlignRight
                        text: qsTr("Download location")
                        smooth: true
                    }

                    Text {
                        font.pixelSize: _STANDARD_FONT_SIZE
                        color: _TEXT_COLOR
                        horizontalAlignment: Text.AlignRight
                        text: qsTr("Safe search")
                        smooth: true
                    }

                    Text {
                        font.pixelSize: _STANDARD_FONT_SIZE
                        color: _TEXT_COLOR
                        horizontalAlignment: Text.AlignRight
                        text: qsTr("Screen orientation")
                        smooth: true
                    }

                    Text {
                        font.pixelSize: _STANDARD_FONT_SIZE
                        color: _TEXT_COLOR
                        horizontalAlignment: Text.AlignRight
                        text: qsTr("Media player")
                        smooth: true
                    }

                    Text {
                        font.pixelSize: _STANDARD_FONT_SIZE
                        color: _TEXT_COLOR
                        horizontalAlignment: Text.AlignRight
                        text: qsTr("Theme")
                        smooth: true
                    }


                    Text {
                        font.pixelSize: _STANDARD_FONT_SIZE
                        color: _TEXT_COLOR
                        horizontalAlignment: Text.AlignRight
                        text: qsTr("Language")
                        smooth: true
                    }

                }

                Column {
                    id: valueColumn

                    anchors { left: divider.right; leftMargin: 10; top: divider.top }
                    spacing: 10

                    Text {
                        id: proxyText

                        width: (dialog.parent.state == "") ? 240 : 180
                        font.pixelSize: _STANDARD_FONT_SIZE
                        color: proxyMouseArea.pressed ? _ACTIVE_COLOR_HIGH : _ACTIVE_COLOR_LOW
                        elide: Text.ElideRight
                        text: (proxy == ":") ? qsTr("None") : proxy
                        smooth: true

                        MouseArea {
                            id: proxyMouseArea

                            width: proxyText.width
                            height: 30
                            anchors.centerIn: parent
                            onClicked: showProxyDialog()
                        }
                    }

                    Text {
                        id: playbackText

                        font.pixelSize: _STANDARD_FONT_SIZE
                        color: playbackMouseArea.pressed ? _ACTIVE_COLOR_HIGH : _ACTIVE_COLOR_LOW
                        text: playbackQuality
                        smooth: true

                        MouseArea {
                            id: playbackMouseArea

                            width: 200
                            height: 30
                            anchors.centerIn: parent
                            onClicked: showSettingsList(qsTr("Playback Quality"), "playbackSettings", playbackQuality)
                        }
                    }

                    Text {
                        id: downloadText

                        font.pixelSize: _STANDARD_FONT_SIZE
                        color: downloadMouseArea.pressed ? _ACTIVE_COLOR_HIGH : _ACTIVE_COLOR_LOW
                        text: downloadQuality
                        smooth: true

                        MouseArea {
                            id: downloadMouseArea

                            width: 200
                            height: 30
                            anchors.centerIn: parent
                            onClicked: showSettingsList(qsTr("Download Quality"), "downloadSettings", downloadQuality)
                        }
                    }

                    Text {
                        id: downloadStatusText

                        font.pixelSize: _STANDARD_FONT_SIZE
                        color: downloadStatusMouseArea.pressed ? _ACTIVE_COLOR_HIGH : _ACTIVE_COLOR_LOW
                        text: downloadStatus
                        smooth: true

                        MouseArea {
                            id: downloadStatusMouseArea

                            width: 200
                            height: 30
                            anchors.centerIn: parent
                            onClicked: showSettingsList(qsTr("Start Downloads"), "downloadStatusSettings", downloadStatus)
                        }
                    }

                    Text {
                        id: downloadPathText

                        width: (dialog.parent.state == "") ? 240 : 180
                        font.pixelSize: _STANDARD_FONT_SIZE
                        color: downloadPathMouseArea.pressed ? _ACTIVE_COLOR_HIGH : _ACTIVE_COLOR_LOW
                        elide: Text.ElideRight
                        text: downloadPath
                        smooth: true

                        MouseArea {
                            id: downloadPathMouseArea

                            width: downloadPathText.width
                            height: 30
                            anchors.centerIn: parent
                            onClicked: showDownloadPathDialog()
                        }
                    }                    

                    Text {
                        id: safeSearchText

                        font.pixelSize: _STANDARD_FONT_SIZE
                        color: safeSearchMouseArea.pressed ? _ACTIVE_COLOR_HIGH : _ACTIVE_COLOR_LOW
                        text: safeSearch
                        smooth: true

                        MouseArea {
                            id: safeSearchMouseArea

                            width: 200
                            height: 30
                            anchors.centerIn: parent
                            onClicked: showSettingsList(qsTr("Safe Search"), "safeSearchSettings", safeSearch)
                        }
                    }

                    Text {
                        id: orientationText

                        font.pixelSize: _STANDARD_FONT_SIZE
                        color: orientationMouseArea.pressed ? _ACTIVE_COLOR_HIGH : _ACTIVE_COLOR_LOW
                        text: screenOrientation
                        smooth: true

                        MouseArea {
                            id: orientationMouseArea

                            width: 200
                            height: 30
                            anchors.centerIn: parent
                            onClicked: showSettingsList(qsTr("Screen Orientation"), "orientationSettings", screenOrientation)
                        }
                    }

                    Text {
                        id: playerText

                        font.pixelSize: _STANDARD_FONT_SIZE
                        color: playerMouseArea.pressed ? _ACTIVE_COLOR_HIGH : _ACTIVE_COLOR_LOW
                        text: mediaPlayer
                        smooth: true

                        MouseArea {
                            id: playerMouseArea

                            width: 200
                            height: 30
                            anchors.centerIn: parent
                            onClicked: showSettingsList(qsTr("Media Player"), "mediaPlayerSettings", mediaPlayer)
                        }
                    }

                    Text {
                        id: themeText

                        font.pixelSize: _STANDARD_FONT_SIZE
                        color: themeMouseArea.pressed ? _ACTIVE_COLOR_HIGH : _ACTIVE_COLOR_LOW
                        text: theme
                        smooth: true

                        MouseArea {
                            id: themeMouseArea

                            width: 200
                            height: 30
                            anchors.centerIn: parent
                            onClicked: showSettingsList(qsTr("Theme"), "themeSettings", theme)
                        }
                    }

                    Text {
                        id: languageText

                        font.pixelSize: _STANDARD_FONT_SIZE
                        color: languageMouseArea.pressed ? _ACTIVE_COLOR_HIGH : _ACTIVE_COLOR_LOW
                        text: language
                        smooth: true

                        MouseArea {
                            id: languageMouseArea

                            width: 200
                            height: 30
                            anchors.centerIn: parent
                            onClicked: showSettingsList(qsTr("Language"), "languageSettings", language)
                        }
                    }
                }
            }

            Text {
                id: widgetSettings
                anchors { top: divider.bottom; topMargin: 20; horizontalCenter: divider.horizontalCenter }
                font.pixelSize: _SMALL_FONT_SIZE
                color: _TEXT_COLOR
                text: "Widget Settings"


                Rectangle {
                    id: widgetDivider

                    width: 1
                    height: widgetSettingColumn.height
                    anchors { top: parent.bottom; topMargin: 20; horizontalCenter: parent.horizontalCenter }
                    color: _ACTIVE_COLOR_LOW

                    Column {
                        id: widgetSettingColumn

                        anchors { right: widgetDivider.left; rightMargin: 10; top: widgetDivider.top }
                        spacing: 10

                        Text {
                            font.pixelSize: _STANDARD_FONT_SIZE
                            color: _TEXT_COLOR
                            horizontalAlignment: Text.AlignRight
                            text: qsTr("Feed One")
                            smooth: true
                        }

                        Text {
                            font.pixelSize: _STANDARD_FONT_SIZE
                            color: _TEXT_COLOR
                            horizontalAlignment: Text.AlignRight
                            text: qsTr("Feed Two")
                            smooth: true
                        }

                        Text {
                            font.pixelSize: _STANDARD_FONT_SIZE
                            color: _TEXT_COLOR
                            horizontalAlignment: Text.AlignRight
                            text: qsTr("Feed Three")
                            smooth: true
                        }

                        Text {
                            font.pixelSize: _STANDARD_FONT_SIZE
                            color: _TEXT_COLOR
                            horizontalAlignment: Text.AlignRight
                            text: qsTr("Feed Four")
                            smooth: true
                        }
                    }

                    Column {
                        id: widgetValueColumn

                        anchors { left: widgetDivider.right; leftMargin: 10; top: widgetDivider.top }
                        spacing: 10

                        Text {
                            id: feedOneText

                            width: (dialog.parent.state == "") ? 240 : 180
                            font.pixelSize: _STANDARD_FONT_SIZE
                            color: feedOneMouseArea.pressed ? _ACTIVE_COLOR_HIGH : _ACTIVE_COLOR_LOW
                            elide: Text.ElideRight
                            text: widgetFeedOne
                            smooth: true

                            MouseArea {
                                id: feedOneMouseArea

                                width: parent.width
                                height: 30
                                anchors.centerIn: parent
                                onClicked: showSettingsList(qsTr("Widget Feed One"), "widgetFeeds", widgetFeedOne)
                            }
                        }

                        Text {
                            id: feedTwoText

                            width: (dialog.parent.state == "") ? 240 : 180
                            font.pixelSize: _STANDARD_FONT_SIZE
                            color: feedTwoMouseArea.pressed ? _ACTIVE_COLOR_HIGH : _ACTIVE_COLOR_LOW
                            elide: Text.ElideRight
                            text: widgetFeedTwo
                            smooth: true

                            MouseArea {
                                id: feedTwoMouseArea

                                width: parent.width
                                height: 30
                                anchors.centerIn: parent
                                onClicked: showSettingsList(qsTr("Widget Feed Two"), "widgetFeeds", widgetFeedTwo)
                            }
                        }

                        Text {
                            id: feedThreeText

                            width: (dialog.parent.state == "") ? 240 : 180
                            font.pixelSize: _STANDARD_FONT_SIZE
                            color: feedThreeMouseArea.pressed ? _ACTIVE_COLOR_HIGH : _ACTIVE_COLOR_LOW
                            elide: Text.ElideRight
                            text: widgetFeedThree
                            smooth: true

                            MouseArea {
                                id: feedThreeMouseArea

                                width: parent.width
                                height: 30
                                anchors.centerIn: parent
                                onClicked: showSettingsList(qsTr("Widget Feed Three"), "widgetFeeds", widgetFeedThree)
                            }
                        }

                        Text {
                            id: feedFourText

                            width: (dialog.parent.state == "") ? 240 : 180
                            font.pixelSize: _STANDARD_FONT_SIZE
                            color: feedFourMouseArea.pressed ? _ACTIVE_COLOR_HIGH : _ACTIVE_COLOR_LOW
                            elide: Text.ElideRight
                            text: widgetFeedFour
                            smooth: true

                            MouseArea {
                                id: feedFourMouseArea

                                width: parent.width
                                height: 30
                                anchors.centerIn: parent
                                onClicked: showSettingsList(qsTr("Widget Feed Four"), "widgetFeeds", widgetFeedFour)
                            }
                        }
                    }
                }
            }
        }

        PushButton {
            id: clearSearchesButton

            width: (dialog.parent.state == "") ?  clearSearchesButton.textWidth + 24 : dialog.width - 20
            anchors { left: background.left; leftMargin: 10; bottom: background.bottom; bottomMargin: (dialog.parent.state == "") ? 10 : 90 }
            showIcon: false
            showText: true
            name: qsTr("Clear saved searches")
            onButtonClicked: clearSearches()
        }

        PushButton {
            id: saveButton

            width: (dialog.parent.state == "") ? 150 : dialog.width - 20
            anchors { right: background.right; bottom: background.bottom; margins: 10 }
            icon: (cuteTubeTheme == "light") ? "ui-images/ticklight.png" : "ui-images/tick.png"

            Connections {
                onButtonClicked: saveSettings()
            }
        }
    }

    CloseButton {
        onButtonClicked: close()
    }

    MouseArea {

        property real xPos

        z: -1
        anchors.fill: dialog
        onPressed: xPos = mouseX
        onReleased: {
            if (xPos - mouseX > 100) {
                close();
            }
        }
    }

    states: [
        State {
            name: "show"
            AnchorChanges { target: dialog; anchors.right: parent.right }
        },

        State {
            name: "showChild"
            AnchorChanges { target: dialog; anchors { left: parent.right; right: undefined } }
        }
    ]

    transitions: Transition {
        AnchorAnimation { easing.type: Easing.OutQuart; duration: 500 }
    }
}
