import Qt 4.7
import "scripts/menu.js" as Menu
import "scripts/createobject.js" as ObjectCreator

Rectangle {
    id: window

    signal uploads(string feed, string title)
    signal favourites(string feed, string title)
    signal playlists
    signal subscriptions
    signal dialogClose

    function changeCurrentUser() {
        /* Raise a dialog enabling the user to choose from available users */

        if (dimmer.state == "") {
            toggleControls(false);
            var userDialog = ObjectCreator.createObject("ChangeUserDialog.qml", window);
            userDialog.close.connect(closeDialogs);
            dimmer.state = "dim";
            userDialog.state = "show";
            mouseArea.enabled = true;
        }
    }

    function showUploadDialog() {
        if (dimmer.state == "") {
            toggleControls(false);
            var uploadDialog = ObjectCreator.createObject("UploadDialog.qml", window);
            uploadDialog.close.connect(closeDialogs);
            dimmer.state = "dim";
            uploadDialog.state = "show";
            mouseArea.enabled = true;
        }
    }

    function closeDialogs() {
        /* Close any open dialogs and return the window to its default state */

        dialogClose();
        dimmer.state = "";
        mouseArea.enabled = false;
        toggleControls(true);
    }

    function toggleMenu() {
        Menu.toggleMenu();
    }

    color: _BACKGROUND_COLOR

    Connections {
        target: YouTube

        onUploadStarted: mouseArea.enabled = false;
    }

    Rectangle {
        id: dimmer

        anchors.fill: window
        color: window.color

        Loader {
            id: menuLoader

            z: 20
            width: dimmer.width / 2
            anchors { left: dimmer.left; bottom: dimmer.bottom; bottomMargin: 60 }

            onLoaded: menuLoader.item.addMenuItems([ { name: qsTr("Upload video") } ])

            Timer {
                id: menuTimer

                interval: 600
                onTriggered: menuLoader.source = ""
            }

            Connections {
                target: menuLoader.item

                onItemClicked: {
                    toggleMenu();
                    if (index == 0) {
                        showUploadDialog();
                    }
                }
            }
        }

        Grid {
            id: buttonGrid

            anchors.centerIn: dimmer
            rows: 2
            columns: 4
            spacing: (window.state == "") ? Math.floor(window.width / 12) : Math.floor(window.height / 12)

            Column {

                PushButton {
                    id: uploadsButton

                    width: (window.state == "") ? (window.width / 6) : (window.height / 6)
                    height: uploadsButton.width
                    smooth: true
                    icon: "ui-images/uploadsicon.png"
                    iconWidth: 100
                    iconHeight: 100
                    onButtonClicked: uploads(_UPLOADS_FEED, qsTr("My Uploads"))
                }

                Text {
                    y: 10
                    width: uploadsButton.width
                    text: qsTr("Uploads")
                    font.pixelSize: _SMALL_FONT_SIZE
                    color: _TEXT_COLOR
                    horizontalAlignment: Text.AlignHCenter
                }
            }

            Column {

                PushButton {
                    id: favouritesButton

                    width: uploadsButton.width
                    height: uploadsButton.height
                    smooth: true
                    icon: "ui-images/favouritesicon.png"
                    iconWidth: 100
                    iconHeight: 100
                    onButtonClicked: favourites(_FAVOURITES_FEED, qsTr("My Favourites"))
                }

                Text {
                    y: 10
                    width: favouritesButton.width
                    text: qsTr("Favourites")
                    font.pixelSize: _SMALL_FONT_SIZE
                    color: _TEXT_COLOR
                    horizontalAlignment: Text.AlignHCenter
                }
            }

            Column {

                PushButton {
                    id: playlistsButton

                    width: uploadsButton.width
                    height: uploadsButton.height
                    smooth: true
                    icon: "ui-images/playlistsicon.png"
                    iconWidth: 100
                    iconHeight: 100
                    onButtonClicked: playlists()
                }

                Text {
                    y: 10
                    width: playlistsButton.width
                    text: qsTr("Playlists")
                    font.pixelSize: _SMALL_FONT_SIZE
                    color: _TEXT_COLOR
                    horizontalAlignment: Text.AlignHCenter
                }
            }

            Column {

                PushButton {
                    id: subscriptionsButton

                    width: uploadsButton.width
                    height: uploadsButton.height
                    smooth: true
                    icon: "ui-images/subscriptionsicon.png"
                    iconWidth: 100
                    iconHeight: 100
                    onButtonClicked: subscriptions()
                }

                Text {
                    y: 10
                    width: subscriptionsButton.width
                    text: qsTr("Subscriptions")
                    font.pixelSize: _SMALL_FONT_SIZE
                    color: _TEXT_COLOR
                    horizontalAlignment: Text.AlignHCenter
                }
            }
        }

        Row {
            anchors { bottom: dimmer.bottom; bottomMargin: 80; right: dimmer.right; rightMargin: 64 }
            spacing: 5

            Text {
                font.pixelSize: _SMALL_FONT_SIZE
                color: _TEXT_COLOR
                text: qsTr("Signed in as:")
            }

            Text {
                id: currentUserText

                font.pixelSize: _SMALL_FONT_SIZE
                color: userMouseArea.pressed ? _ACTIVE_COLOR_HIGH : _ACTIVE_COLOR_LOW
                text: YouTube.currentUser

                MouseArea {
                    id: userMouseArea

                    width: 200
                    height: 70
                    anchors.centerIn: currentUserText
                    onClicked: changeCurrentUser()
                }
            }

        }

        MouseArea {
            id: mouseArea

            anchors.fill: dimmer
            enabled: false
            onClicked: closeDialogs()
        }

        states: State {
            name: "dim"
            PropertyChanges { target: dimmer; opacity: 0.3 }
        }

        transitions: Transition {
            PropertyAnimation { target: dimmer; properties: "opacity"; duration: 500 }
        }
    }

    states: State {
        name: "portrait"
        when: window.height > window.width
        PropertyChanges { target: buttonGrid; columns: 2 }
    }
}
