#include "youtube.h"
#include <QtNetwork/QNetworkRequest>
#include <QtNetwork/QNetworkReply>
#include <QString>
#include <QRegExp>
#include <QUrl>
#include <QDebug>
#include <QMap>
#include <QStringList>
#include <QTimer>

YouTube::YouTube(QObject *parent) :
    QObject(parent), developerKey("AI39si6x9O1gQ1Z_BJqo9j2n_SdVsHu1pk2uqvoI3tVq8d6alyc1og785IPCkbVY3Q5MFuyt-IFYerMYun0MnLdQX5mo2BueSw"), playbackFormat(18) {
    pbMap["High quality"] = 18;
    pbMap["Mobile"] = 5;
}

void YouTube::setNetworkAccessManager(QNetworkAccessManager *manager) {
    nam = manager;
}

void YouTube::setPlaybackQuality(const QString &quality) {
    playbackFormat = pbMap.value(quality, 18);
}

void YouTube::login(const QString &username, const QString &password) {
    setCurrentUser(username, password);
    QNetworkRequest request(QUrl("https://www.google.com/accounts/ClientLogin"));
    request.setHeader(QNetworkRequest::ContentTypeHeader, "application/x-www-form-urlencoded");
    QByteArray loginData("Email=" + username.toAscii() + "&Passwd=" + password.toAscii() + "&service=youtube&source=cuteTube");
    QNetworkReply* reply = nam->post(request, loginData);
    connect(reply, SIGNAL(finished()), this, SLOT(checkLogin()));
}

void YouTube::checkLogin() {
    QNetworkReply* reply = qobject_cast<QNetworkReply*>(sender());
    if (!reply) {
        setCurrentUser("", "");
        emit alert(tr("Error obtaining access token"));
        return;
    }

    QByteArray response = reply->readAll();
    QList<QByteArray> sp = response.split('=');
    setAccessToken(sp.last().trimmed());

    if (getAccessToken() == "BadAuthentication") {
        setCurrentUser("", "");
        emit alert(tr("Authentication failed"));
    }
    else {
        emit alert(tr("You are signed in to YouTube as '") + getCurrentUser() + "'");
    }
    reply->deleteLater();
}

void YouTube::setCurrentUser(const QString &user, const QString &pass) {
    currentUser = user;
    currentUserPass = pass;
    emit currentUserChanged();
}

void YouTube::setAccessToken(const QByteArray &token) {
    accessToken = token;
    emit accessTokenChanged(accessToken);
}

void YouTube::uploadVideo(const QString &filename, const QString &title, const QString &description, const QString &tags, const QString &category, const bool &isPrivate) {

    fileToBeUploaded = new QFile(filename);

    QUrl url("http://uploads.gdata.youtube.com/resumable/feeds/api/users/default/uploads");
    QByteArray xml("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" \
                   "<entry xmlns=\"http://www.w3.org/2005/Atom\"\n" \
                   "xmlns:media=\"http://search.yahoo.com/mrss/\"\n" \
                   "xmlns:yt=\"http://gdata.youtube.com/schemas/2007\">\n" \
                   "<media:group>\n" \
                   "<media:title>" + title.toAscii() + "</media:title>\n" \
                   "<media:description>\n" + description.toAscii() + "\n\n" + "Uploaded via cuteTube on the Nokia N900\n</media:description>\n" \
                   "<media:category scheme=\"http://gdata.youtube.com/schemas/2007/categories.cat\">\n" + category.toAscii() + "\n</media:category>\n" \
                   "<media:keywords>" + tags.toAscii() + "</media:keywords>\n" \
                   "</media:group>\n" \
                   "</entry>");

    if (isPrivate) {
        int index = xml.lastIndexOf("<");
        xml.insert(index, "<yt:private/>\n");
    }

    QNetworkRequest request(url);
    request.setRawHeader("Host", "uploads.gdata.youtube.com");
    request.setHeader(QNetworkRequest::ContentTypeHeader, "application/atom+xml; charset=UTF-8");
    request.setHeader(QNetworkRequest::ContentLengthHeader, xml.length());
    request.setRawHeader("Authorization", "GoogleLogin auth=" + accessToken.toAscii());
    request.setRawHeader("GData-Version", "2");
    request.setRawHeader("X-Gdata-Key", "key=" + developerKey);
    request.setRawHeader("Slug", filename.split("/").last().toAscii());
    uploadReply = nam->post(request, xml);
    connect(uploadReply, SIGNAL(finished()), this, SLOT(setUploadUrl()));
}

void YouTube::setUploadUrl() {
    if (uploadReply->error())
        return;

    int statusCode = uploadReply->attribute(QNetworkRequest::HttpStatusCodeAttribute).toInt();
    QByteArray statusText = uploadReply->attribute(QNetworkRequest::HttpReasonPhraseAttribute).toByteArray();
    //qDebug() << "Status is:" << statusCode << ":" << statusText;
    if (statusCode == 200) {
        uploadUrl = QUrl(uploadReply->rawHeader("Location"));
        //        qDebug() << uploadUrl;
        performVideoUpload();
    }
    else {
        emit alert(tr("Error - Server repsonse is: ") + statusText);
    }
}

void YouTube::performVideoUpload() {
    uploadRetries = 3;

    fileToBeUploaded->open(QIODevice::ReadOnly);
    QNetworkRequest request(uploadUrl);
    request.setRawHeader("Host", "uploads.gdata.youtube.com");
    request.setHeader(QNetworkRequest::ContentTypeHeader, "application/octet-stream");
    request.setHeader(QNetworkRequest::ContentLengthHeader, fileToBeUploaded->size());
    uploadReply = nam->put(request, fileToBeUploaded);
    connect(uploadReply, SIGNAL(uploadProgress(qint64,qint64)), this, SIGNAL(updateUploadProgress(qint64,qint64)));
    connect(uploadReply, SIGNAL(finished()), this, SLOT(uploadFinished()));
    emit uploadStarted();
}

void YouTube::resumeVideoUpload() {
    uploadRetries--;

    QByteArray rangeHeader = uploadReply->rawHeader("Range");
    QByteArray startByte = rangeHeader.split('-').last();
    QByteArray locationHeader = uploadReply->rawHeader("Location");

    //qDebug() << rangeHeader << startByte << locationHeader;

    if (locationHeader.length() > 0) {
        uploadUrl = QUrl(locationHeader);
    }

    fileToBeUploaded->open(QIODevice::ReadOnly);
    int fs = fileToBeUploaded->size();
    QByteArray fileSize = QByteArray::number(fs);
    QByteArray endByte = QByteArray::number(fs - 1);
    QByteArray range(startByte + '-' + endByte + '/' + fileSize);
    QNetworkRequest request(uploadUrl);
    request.setRawHeader("Host", "uploads.gdata.youtube.com");
    request.setHeader(QNetworkRequest::ContentTypeHeader, "application/octet-stream");
    request.setHeader(QNetworkRequest::ContentLengthHeader, fs - startByte.toInt());
    request.setRawHeader("Content-Range", range);
    uploadReply = nam->put(request, fileToBeUploaded);
    connect(uploadReply, SIGNAL(uploadProgress(qint64,qint64)), this, SIGNAL(updateUploadProgress(qint64,qint64)));
    connect(uploadReply, SIGNAL(finished()), this, SLOT(uploadFinished()));
    emit uploadStarted();
}

void YouTube::abortVideoUpload() {
    uploadReply->abort();
    fileToBeUploaded->close();
    emit uploadCompleted("<font color='yellow'>" + tr("Upload aborted") + "<font>");
}

void YouTube::uploadFinished() {
    fileToBeUploaded->close();

    if (uploadReply->error()) {
        if (uploadReply->error() == QNetworkReply::OperationCanceledError) {
            emit uploadCompleted("<font color='yellow'>" + tr("Upload aborted") + "<font>");
            return;
        }
        else {
            int statusCode = uploadReply->attribute(QNetworkRequest::HttpStatusCodeAttribute).toInt();
            if (statusCode == 308) {
                if (uploadRetries > 0) {
                    emit uploadCompleted("<font color='yellow'>" + tr("Upload interrupted. Attempting to resume...") + "<font>");
                    QTimer::singleShot(3000, this, SLOT(resumeVideoUpload()));
                }
                else {
                    emit uploadCompleted("<font color='red'>" + tr("Upload failed") + "<font>");
                }
            }
        }
    }
    else {
        emit uploadCompleted("<font color='green'>" + tr("Upload is completed") + "<font>");
    }
}

void YouTube::postRequest(const QUrl &url, const QByteArray &xml) {
    /* Helper method that posts HTTP POST requests */

    QNetworkRequest request(url);
    request.setRawHeader("Host", "gdata.youtube.com");
    request.setHeader(QNetworkRequest::ContentTypeHeader, "application/atom+xml");
    request.setHeader(QNetworkRequest::ContentLengthHeader, xml.length());
    request.setRawHeader("Authorization", "GoogleLogin auth=" + accessToken.toAscii());
    request.setRawHeader("GData-Version", "2");
    request.setRawHeader("X-Gdata-Key", "key=" + developerKey);
    QNetworkReply* reply = nam->post(request, xml);
    connect(reply, SIGNAL(finished()), this, SLOT(postFinished()));
}

void YouTube::postFinished() {
    QNetworkReply* reply = qobject_cast<QNetworkReply*>(sender());
    if (!reply) {
        return;
    }

    int statusCode = reply->attribute(QNetworkRequest::HttpStatusCodeAttribute).toInt();
    QByteArray statusText = reply->attribute(QNetworkRequest::HttpReasonPhraseAttribute).toByteArray();
    //qDebug() << "Status is:" << statusCode << ":" << statusText;
    if ((statusCode == 200) || (statusCode == 201)) {
        emit postSuccessful();
    }
    else {
        emit alert(tr("Error - Server repsonse is: ") + statusText);
    }
    reply->deleteLater();
}

void YouTube::deleteRequest(const QUrl &url) {
    /* Helper method that posts HTTP DELETE requests */

    QNetworkRequest request(url);
    request.setRawHeader("Host", "gdata.youtube.com");
    request.setHeader(QNetworkRequest::ContentTypeHeader, "application/atom+xml");
    request.setRawHeader("Authorization", "GoogleLogin auth=" + accessToken.toAscii());
    request.setRawHeader("GData-Version", "2");
    request.setRawHeader("X-Gdata-Key", "key=" + developerKey);
    QNetworkReply* reply = nam->deleteResource(request);
    connect(reply, SIGNAL(finished()), this, SLOT(postFinished()));
}

void YouTube::addToFavourites(const QString &videoId) {
    QUrl url("http://gdata.youtube.com/feeds/api/users/default/favorites");
    QByteArray xml("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" \
                   "<entry xmlns=\"http://www.w3.org/2005/Atom\">\n" \
                   "<id>" + videoId.toAscii() + "</id>\n" \
                   "</entry>");
    postRequest(url, xml);
    connect(this, SIGNAL(postSuccessful()), this, SIGNAL(addedToFavourites()));
}

void YouTube::deleteFromFavourites(const QString &favouriteId) {
    QUrl url("http://gdata.youtube.com/feeds/api/users/" + currentUser + "/favorites/" + favouriteId);
    deleteRequest(url);

}

void YouTube::addToPlaylist(const QString &videoId, const QString &playlistId) {
    QUrl url("http://gdata.youtube.com/feeds/api/playlists/" + playlistId);
    QByteArray xml("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" \
                   "<entry xmlns=\"http://www.w3.org/2005/Atom\"\n" \
                   "xmlns:yt=\"http://gdata.youtube.com/schemas/2007\">\n" \
                   "<id>" + videoId.toAscii() + "</id>\n" \
                   "</entry>");
    postRequest(url, xml);
    connect(this, SIGNAL(postSuccessful()), this, SIGNAL(addedToPlaylist()));
}

void YouTube::deleteFromPlaylist(const QString &playlistId, const QString &playlistVideoId) {
    QUrl url("http://gdata.youtube.com/feeds/api/playlists/" + playlistId + "/" + playlistVideoId);
    deleteRequest(url);
}

void YouTube::createNewPlaylist(const QString &title, const QString &description, const bool &isPrivate) {
    QUrl url("http://gdata.youtube.com/feeds/api/users/default/playlists");
    QByteArray xml("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" \
                   "<entry xmlns=\"http://www.w3.org/2005/Atom\"\n" \
                   "xmlns:yt=\"http://gdata.youtube.com/schemas/2007\">\n" \
                   "<title>" + title.toAscii() + "</title>\n" \
                   "<summary>" + description.toAscii() + "</summary>\n" \
                   "</entry>");
    if (isPrivate) {
        int index = xml.lastIndexOf("<");
        xml.insert(index, "<yt:private/>\n");
    }
    postRequest(url, xml);
    connect(this, SIGNAL(postSuccessful()), this, SIGNAL(playlistCreated()));
}

void YouTube::deletePlaylist(const QString &playlistId) {
    QUrl url("http://gdata.youtube.com/feeds/api/users/" + currentUser + "/playlists/" + playlistId);
    deleteRequest(url);
}

void YouTube::subscribeToChannel(const QString &username) {
    QUrl url("http://gdata.youtube.com/feeds/api/users/default/subscriptions");
    QByteArray xml("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" \
                   "<entry xmlns=\"http://www.w3.org/2005/Atom\"\n" \
                   "xmlns:yt=\"http://gdata.youtube.com/schemas/2007\">\n" \
                   "<category scheme=\"http://gdata.youtube.com/schemas/2007/subscriptiontypes.cat\"\n" \
                   "term=\"channel\"/>\n" \
                   "<yt:username>" + username.toAscii() + "</yt:username>\n" \
                   "</entry>");
    postRequest(url, xml);
    connect(this, SIGNAL(postSuccessful()), this, SIGNAL(subscribed()));
}

void YouTube::unsubscribeToChannel(const QString &subscriptionId) {
    QUrl url("http://gdata.youtube.com/feeds/api/users/" + currentUser + "/subscriptions/" + subscriptionId);
    deleteRequest(url);
    connect(this, SIGNAL(postSuccessful()), this, SIGNAL(unsubscribed()));
}

void YouTube::rateVideo(const QString &videoId, const QString &likeOrDislike) {
    QUrl url("http://gdata.youtube.com/feeds/api/videos/" + videoId + "/ratings");
    QByteArray xml("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" \
                   "<entry xmlns=\"http://www.w3.org/2005/Atom\"\n" \
                   "xmlns:yt=\"http://gdata.youtube.com/schemas/2007\">\n" \
                   "<yt:rating value=\"" + likeOrDislike.toAscii() + "\"/>\n" \
                   "</entry>");
    postRequest(url, xml);
    connect(this, SIGNAL(postSuccessful()), this, SIGNAL(videoRated()));
}

void YouTube::addComment(const QString &videoId, const QString &comment) {
    QUrl url("http://gdata.youtube.com/feeds/api/videos/" + videoId + "/comments");
    QByteArray xml("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" \
                   "<entry xmlns=\"http://www.w3.org/2005/Atom\"\n" \
                   "xmlns:yt=\"http://gdata.youtube.com/schemas/2007\">\n" \
                   "<content>" + comment.toAscii() + "</content>\n" \
                   "</entry>");
    postRequest(url, xml);
    connect(this, SIGNAL(postSuccessful()), this, SIGNAL(commentAdded()));
}

void YouTube::replyToComment(const QString &videoId, const QString &commentId, const QString &comment) {
    QUrl url("http://gdata.youtube.com/feeds/api/videos/" + videoId + "/comments");
    QByteArray xml("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" \
                   "<entry xmlns=\"http://www.w3.org/2005/Atom\"\n" \
                   "xmlns:yt=\"http://gdata.youtube.com/schemas/2007\">\n" \
                   "<link rel=\"http://gdata.youtube.com/schemas/2007#in-reply-to\"\n" \
                   "type=\"application/atom+xml\"\n" \
                   "href=\"http://gdata.youtube.com/feeds/api/videos/" + videoId.toAscii() + "/comments/" + commentId.toAscii() + "\"/>\n" \
                   "<content>" + comment.toAscii() + "</content>\n" \
                   "</entry>");
    postRequest(url, xml);
}

void YouTube::getVideoUrl(const QString &playerUrl) {
    QNetworkAccessManager *manager = new QNetworkAccessManager(this);
    QNetworkRequest request;
    request.setUrl(QUrl(playerUrl));
    connect(manager, SIGNAL(finished(QNetworkReply*)), this, SLOT(parseVideoPage(QNetworkReply*)));
    manager->get(request);

}

void YouTube::parseVideoPage(QNetworkReply *reply) {
    QNetworkAccessManager *manager = qobject_cast<QNetworkAccessManager*>(sender());

    QMap<int, QByteArray> formats;
    QByteArray response = reply->readAll();
    response = response.simplified().replace(QByteArray(" "), QByteArray(""));
    int pos = response.indexOf("\",\"fmt_url_map\":\"") + 17;
    int pos2 = response.indexOf('\"', pos);
    response = response.mid(pos, pos2 - pos);
    QList<QByteArray> parts = response.split('|');
    int key = parts.first().toInt();
    for (int i = 1; i < parts.length(); i++) {
        QByteArray part = parts[i];
        QList<QByteArray> keyAndValue = part.split(',');
        QByteArray url = keyAndValue.first().replace(QByteArray("\\/"), QByteArray("/")).replace(QByteArray("\\u0026"), QByteArray("&"));
        formats[key] = url;
        key = keyAndValue.last().toInt();
    }
    QList<int> flist;
    flist << 22 << 35 << 34 << 18 << 5;
    QByteArray videoUrl = "";
    int index = flist.indexOf(playbackFormat);
    while ((videoUrl == "") && index < flist.size()) {
        videoUrl = formats.value(flist.at(index), "");
        index++;
    }
    if (videoUrl == "") {
        emit alert(tr("Error: Unable to retrieve video"));
        emit videoUrlError();
    }
    else {
        emit gotVideoUrl(QString(videoUrl));
    }
    reply->deleteLater();
    manager->deleteLater();
}
