import QtQuick 1.0
import "scripts/videolistscripts.js" as Scripts
import "scripts/menu.js" as Menu
import "scripts/createobject.js" as ObjectCreator

Rectangle {
    id: window

    property string videoFeed

    signal goToVideo(variant video)
    //    signal playVideos(variant videos)
    signal dialogClose

    function setVideoFeed(feed) {
        videoFeed = feed;
        var doc = new XMLHttpRequest();
        doc.onreadystatechange = function() {
            if (doc.readyState == XMLHttpRequest.DONE) {
                var xml = doc.responseText;
                videoListModel.setXml(xml);

                videoListModel.loading = false;
            }
        }
        doc.open("GET", feed);
        if ((feed == _FAVOURITES_FEED) || (feed == _UPLOADS_FEED) || (feed == _NEW_SUB_VIDEOS_FEED)) {
            doc.setRequestHeader("Authorization", "GoogleLogin auth=" + YouTube.accessToken); // Set 'Authorization' header if viewing the favourites/uploads feed
        }
        doc.send();
    }

    function toggleMenu() {
        Menu.toggleMenu();
    }

    color: _BACKGROUND_COLOR

    Item {
        id: dimmer

        anchors.fill: window

        Behavior on opacity { PropertyAnimation { properties: "opacity"; duration: 500 } }

        Loader {
            id: menuLoader

            property bool pencilOn : false

            z: 20
            width: dimmer.width / 2
            anchors { left: dimmer.left; bottom: dimmer.bottom; bottomMargin: 60 }

            onLoaded: {
                menuLoader.item.pencilOn = menuLoader.pencilOn;
                menuLoader.item.addMenuItems([ { name: qsTr("Multi-select") } ]);
                if (videoList.checkList.length > 0) {
                    menuLoader.item.addMenuItems([ { name: qsTr("Download video") }, { name: qsTr("Download audio") },
                                                  { name: qsTr("Add to favourites") }, { name: qsTr("Add to playlist") }, { name: qsTr("Copy to clipboard") } ])
                }
            }

            onPencilOnChanged: menuLoader.item.pencilOn = menuLoader.pencilOn

            Timer {
                id: menuTimer

                interval: 600
                onTriggered: menuLoader.source = ""
            }

            Connections {
                target: menuLoader.item

                onItemClicked: {
                    toggleMenu();
                    if (index == 0) {
                        videoList.checkList = [];
                    }
                    else if (index == 1) {
                        Scripts.addVideosToDownloads(false);
                    }
                    else if (index == 2) {
                        Scripts.addVideosToDownloads(true);
                    }
                    else if (index == 3) {
                        if (userIsSignedIn()) {
                            Scripts.addVideosToFavourites();
                        }
                    }
                    else if (index == 4) {
                        if (userIsSignedIn()) {
                            Scripts.showPlaylistDialog();
                        }
                    }
                    else if (index == 5) {
                        Scripts.copyVideosToClipboard();
                    }
                    menuLoader.pencilOn = !menuLoader.pencilOn;
                }
            }
        }

        Text {
            id: noResultsText

            anchors.centerIn: dimmer
            font.pixelSize: _LARGE_FONT_SIZE
            font.bold: true
            color: "grey"
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            text: qsTr("No videos found")
            visible: false

            Timer {
                interval: 5000
                running: (!videoListModel.loading) && (videoListModel.count == 0)
                onTriggered: {
                    if (videoListModel.count == 0) {
                        noResultsText.visible = true;
                    }
                }
            }
        }

        ListView {
            id: videoList

            property variant checkList : []

            anchors { fill: dimmer; topMargin: 50 }
            boundsBehavior: Flickable.DragOverBounds
            highlightMoveDuration: 500
            preferredHighlightBegin: 0
            preferredHighlightEnd: 100
            highlightRangeMode: ListView.StrictlyEnforceRange
            cacheBuffer: 2500
            interactive: visibleArea.heightRatio < 1

            footer: Rectangle {
                id: footer

                width: videoList.width
                height: 100
                color: _BACKGROUND_COLOR
                visible: ((videoListModel.loading) || (videoListModel.status == XmlListModel.Loading))
                opacity: footer.visible ? 1 : 0

                BusyDialog {
                    anchors.centerIn: footer
                    opacity: footer.opacity
                }
            }

            Behavior on opacity { PropertyAnimation { properties: "opacity"; duration: 500 } }

            model: VideoListModel {
                id: videoListModel

                property bool loading : true
            }
            onCurrentIndexChanged: {
                if ((videoList.count - videoList.currentIndex == 15)
                        && (videoList.count < videoListModel.totalResults)
                        && (videoListModel.status == XmlListModel.Ready)) {
                    Scripts.appendVideoFeed();
                }
            }

            delegate: VideoListDelegate {
                id: delegate

                function checkOrGoToVideo() {
                    if (menuLoader.pencilOn) {
                        var cl = videoList.checkList;
                        if (!delegate.checked) {
                            cl.push(index);
                        }
                        else {
                            for (var i = 0; i < cl.length; i++) {
                                if (cl[i] == index) {
                                    cl.splice(i, 1);
                                }
                            }
                        }
                        videoList.checkList = cl;
                    }
                    else {
                        goToVideo(videoListModel.get(index));
                    }
                }

                checked: Scripts.indexInCheckList(index)
                onDelegateClicked: checkOrGoToVideo()
                onDelegatePressed: Scripts.showVideoDialog(index)
                onPlayClicked: YouTube.getVideoUrl(playerUrl)
            }

            ScrollBar {}
        }

        MouseArea {
            id: mouseArea

            anchors { fill: dimmer; topMargin: 50 }
            enabled: false
            onClicked: Scripts.closeDialogs()
        }

        states: State {
            name: "dim"
            PropertyChanges { target: dimmer; opacity: 0.3 }
        }

    }

    states: State {
        name: "portrait"
        when: window.height > window.width
    }
}
