import QtQuick 1.0

Item {

    id: button

    width: parent.width / 2
    height: parent.height

    property alias name : title.text
    property alias icon : icon.source
    property alias showIcon : icon.visible
    property alias showText : title.visible

    signal buttonClicked
    signal buttonPressed

    Rectangle {
        id: background

        anchors.fill: button
        gradient: Gradient {
            GradientStop { position: 0.0; color: _ACTIVE_COLOR_HIGH }
            GradientStop { position: 0.7; color: _ACTIVE_COLOR_LOW }
        }
        smooth: true
        opacity: mouseArea.pressed ? 1 : 0.7
    }

    Text {
        id: title

        anchors.centerIn: button
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        font.pixelSize: _STANDARD_FONT_SIZE
        font.bold: true
        color: "white"
        smooth: true
    }

    Image {
        id: icon

        width: 50
        height: 50
        anchors.centerIn: button
        sourceSize.width: icon.width
        sourceSize.height: icon.height
        smooth: true
        visible: false
    }

    MouseArea {
        id: mouseArea

        anchors.fill: button
        onClicked: buttonClicked()
        onPressAndHold: buttonPressed()
    }
}




