import Qt 4.7

Rectangle {
    id: delegate

    signal delegateClicked
    signal delegatePressed

    width: parent.width
    height: 101
    color: backgroundColor

    ListHighlight {
        visible: mouseArea.pressed
    }

    Text {
        id: titleText

        elide: Text.ElideRight
        text: title
        color: textColor
        font.pixelSize: standardFontSize
        anchors.fill: parent
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
    }

    Text {
        elide: Text.ElideRight
        text: videoCount + qsTr(" videos")
        color: "grey"
        font.pixelSize: smallFontSize
        anchors.rightMargin: 5
        anchors.fill: parent
        horizontalAlignment: Text.AlignRight
        verticalAlignment: Text.AlignVCenter
    }

    Rectangle {
        height: 1
        anchors { bottom: delegate.bottom; left: delegate.left; leftMargin: 10; right: delegate.right; rightMargin: 10 }
        color: activeColorHigh
        opacity: 0.5
        visible: !(index == delegate.ListView.view.count - 1)
    }

    MouseArea {
        id: mouseArea

        anchors.fill: delegate
        onClicked: delegateClicked()
        onPressAndHold: delegatePressed()
    }
}
