import Qt 4.7

Rectangle {
    id: filter

    property alias filterString : filterInput.text

    signal filterChanged(string text)

    height: 0
    color:  "white"
    border.width: 2
    border.color: activeColorLow
    radius: 5
    smooth: true
    visible: height > 0
    focus: true

    Component.onCompleted: filter.state = "show"

    Behavior on height { PropertyAnimation { properties: "height"; easing.type: Easing.OutQuart; duration: 500 } }

    TextInput {
        id: filterInput

        anchors { fill: filter; margins: 2 }
        font.pixelSize: standardFontSize
        selectByMouse: true
        selectionColor: activeColorLow
        smooth: true
        focus: true
        onTextChanged: filterChanged(filterInput.text)
    }

    states: State {
        name: "show"
        PropertyChanges { target: filter; height: 50 }
    }
}
