import Qt 4.7

Item {
    id: dialog

    property string uploadStatus : qsTr("Starting upload")

    signal close

    function setDetails(filename, title) {
        filenameText.text = filename;
        titleText.text = title;
    }

    width: 600
    height: 310

    Rectangle {
        anchors.fill: dialog
        color: "black"
        opacity: 0.5
        radius: 10
        border.width: 2
        border.color: activeColor
        smooth: true
    }

    Text {
        id: title

        anchors { horizontalCenter: parent.horizontalCenter; top: parent.top; topMargin: 10 }
        font.pixelSize: smallFontSize
        color: "white"
        text: qsTr("Upload Progress")
    }

    Column {
        id: column

        anchors { left: dialog.left; leftMargin: 10; right: dialog.right; rightMargin: 180; top: dialog.top; topMargin: 50 }
        spacing: 10

        Text {
            font.pixelSize: smallFontSize
            color: "grey"
            text: qsTr("Filename")
        }

        Text {
            id: filenameText

            anchors { left: column.left; right: column.right; rightMargin: 10 }
            font.pixelSize: standardFontSize
            elide: Text.ElideRight
            color: "white"
        }

        Text {
            font.pixelSize: smallFontSize
            color: "grey"
            text: qsTr("Title")
        }

        Text {
            id: titleText

            anchors { left: column.left; right: column.right; rightMargin: 10 }
            font.pixelSize: standardFontSize
            elide: Text.ElideRight
            color: "white"
        }

        Text {
            id: resultText

            anchors.left: parent.left
            font.pixelSize: smallFontSize
            color: activeColorLow
            text:  uploadStatus
        }
    }

    ProgressBar {
        id: progressBar

        height: 70
        width: 420
        anchors { left: dialog.left; bottom: dialog.bottom; margins: 10 }
    }

    PushButton {
        id: cancelButton

        anchors { right: parent.right; bottom: parent.bottom; margins: 10 }
        name: uploadStatus == "Upload is in progress" ? qsTr("Abort") : qsTr("Close")
        showText: true
        showIcon: false

        Connections {
            onButtonClicked: {
                if (uploadStatus == "Upload is in progress") {
                    YouTube.abortVideoUpload();
                }
                else {
                    close();
                }
            }
        }
    }

    MouseArea {
        z: -1
        anchors.fill: dialog
    }

    Connections {
        target: YouTube

        onUploadStarted: uploadStatus = qsTr("Upload is in progress");
        onUpdateUploadProgress: {
            progressBar.received = bytesSent;
            progressBar.total = bytesTotal;
        }
        onUploadCompleted: uploadStatus = status
    }

    states: State {
        name: "portrait"
        PropertyChanges { target: dialog; width: 460; height: 400 }
        PropertyChanges { target: column; anchors.rightMargin: 10 }
        AnchorChanges { target: progressBar; anchors.bottom: cancelButton.top }
        PropertyChanges { target: progressBar; width: 440 }
        PropertyChanges { target: cancelButton; width: 440 }
    }
}
