import Qt 4.7

Item {
    id: dialog

    width: 600
    height: 300

    Rectangle {
        id: background

        anchors.fill: dialog
        color: "black"
        opacity: 0.5
        radius: 10
        border.width: 2
        border.color: activeColor
    }

    Image {
        id: icon

        width: 100
        height: 100
        anchors { top: background.top; topMargin: 10; horizontalCenter: background.horizontalCenter }
        smooth: true
        source: "ui-images/cutetubehires.png"
    }

    Text {
        id: title

        anchors { top: icon.bottom; topMargin: 10; horizontalCenter: background.horizontalCenter }
        color: "white"
        font { pixelSize: largeFontSize; bold: true }
        text: qsTr("cuteTube-QML - 0.4.2")
    }

    Text {
        id: description

        anchors { top: title.bottom; left: background.left; right: background.right; margins: 10 }
        color: "white"
        font.pixelSize: standardFontSize
        wrapMode: TextEdit.WordWrap
        horizontalAlignment: TextEdit.AlignHCenter
        textFormat: Text.RichText
        text: qsTr("A feature-rich YouTube client for the Nokia N900. This is an experimental release using QML. <br><br> &copy; Stuart Howarth 2011")
    }

    MouseArea {
        z: -1
        anchors.fill: dialog
    }

    states: State {
        name: "portrait"
        PropertyChanges { target: dialog; width: 460; height: 340 }
    }
}
