import QtQuick 1.0

Item {
    id: box

    property alias icon: icon.source
    property alias iconWidth: icon.width
    property alias iconHeight: icon.height
    property alias showIcon: icon.visible
    property alias name : label.text
    property alias showText: label.visible

    width: 50
    height: 25

    Rectangle {
        id: background

        anchors.fill: box
        radius: 5
        color: "black"
        border.width: 2
        border.color: activeColorLow
        opacity: 0.5
        smooth: true
    }

    Image {
        id: icon

        anchors.centerIn: box
        width: 40
        height: 40
        smooth: true
        visible: false
    }

    Text {
        id: label

        anchors.fill: box
        font.pixelSize: smallFontSize
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        color: "white"
        smooth: true
    }
}



