import QtQuick 1.0
import "menu.js" as Menu

Rectangle {
    id: window

    property alias dimmerState : dimmer.state

    signal myChannel
    signal mostRecent
    signal mostViewed
    signal archive

    function showNoAccountDialog() {
        if (dialog.source == "") {
            dialog.source = "NoAccountDialog.qml";
            dialog.item.close.connect(closeDialogs);
            dimmer.state = "dim";
            mouseArea.enabled = true;
        }
    }

    function showSettingsDialog() {
        if (dialog.source == "") {
            dialog.source = "SettingsDialog.qml";
            dialog.item.saveClicked.connect(closeDialogs);
            dimmer.state = "dim";
            mouseArea.enabled = true;
        }
    }

    function showAboutDialog() {
        if (dialog.source == "") {
            dialog.source = "AboutDialog.qml";
            dimmer.state = "dim";
            mouseArea.enabled = true;
        }
    }

    function showAccountsDialog() {
        /* Show the accounts dialog */

        if (dialog.source == "") {
            dialog.source = "AccountsDialog.qml";
            dimmer.state = "dim";
            mouseArea.enabled = true;
        }
    }

    function showConfirmExitDialog() {
        /* If a download is taking place, show
          a confirmation dialog */

        if (dialog.source == "") {
            dialog.source = "ConfirmExitDialog.qml";
            dialog.item.close.connect(closeDialogs);
            dimmer.state = "dim";
            mouseArea.enabled = true;
        }
    }

    function rotateDialogs() {
        if (dialog.source != "") {
            dialog.item.state = window.state;
        }
    }

    function closeDialogs() {
        /* Close any open dialogs and return the window to its default state */

        dialog.state = "";
        timer.running = true;
        dimmer.state = "";
        mouseArea.enabled = false;
    }

    function toggleMenu() {
        Menu.toggleMenu();
    }

    color: "black"
    onStateChanged: rotateDialogs()

    Loader {
        id: dialog

        anchors { top: window.bottom; topMargin: 10; horizontalCenter: window.horizontalCenter }
        z: 1
        onLoaded: {
            dialog.item.state = window.state;
            dialog.state = "show";
        }

        Timer {
            id: timer

            interval: 600
            onTriggered: dialog.source = ""
        }

        states: State {
            name: "show"
            AnchorChanges { target: dialog; anchors { top: undefined; verticalCenter: window.verticalCenter } }
        }

        transitions: Transition {
            AnchorAnimation { easing.type: Easing.OutQuart; duration: 500 }
        }
    }

    Rectangle {
        id: dimmer

        anchors.fill: window
        color: window.color

        Loader {
            id: menuLoader

            z: 20
            width: dimmer.width / 2
            anchors { left: dimmer.left; bottom: dimmer.bottom; bottomMargin: 60 }

            onLoaded: menuLoader.item.addMenuItems([ { name: "Settings" }, { name: "Accounts" }, { name: "About" } ])

            Timer {
                id: menuTimer

                interval: 600
                onTriggered: menuLoader.source = ""
            }

            Connections {
                target: menuLoader.item

                onItemClicked: {
                    toggleMenu();
                    if (index == 0) {
                        showSettingsDialog();
                    }
                    else if (index == 1) {
                        showAccountsDialog();
                    }
                    else if (index == 2) {
                        showAboutDialog();
                    }
                }
            }
        }

        Grid {
            id: buttonGrid

            anchors.centerIn: dimmer
            rows: 2
            columns: 4
            spacing: 64

            Column {

                PushButton {
                    id: myAccountButton

                    width: 120
                    height: 120
                    smooth: true
                    icon: "ui-images/myaccounticon.png"
                    iconWidth: 100
                    iconHeight: 100

                    Connections {
                        onButtonClicked: myChannel()
                    }
                }

                Text {
                    x: 0
                    y: 10
                    width: 120
                    text: "My Channel"
                    font.pixelSize: smallFontSize
                    color: "white"
                    horizontalAlignment: Text.AlignHCenter
                }
            }

            Column {

                PushButton {
                    id: mostRecentButton

                    width: 120
                    height: 120
                    smooth: true
                    icon: "ui-images/mostrecenticon.png"
                    iconWidth: 100
                    iconHeight: 100

                    Connections {
                        onButtonClicked: mostRecent()
                    }
                }

                Text {
                    x: 0
                    y: 10
                    width: 120
                    text: "Most Recent"
                    font.pixelSize: smallFontSize
                    color: "white"
                    horizontalAlignment: Text.AlignHCenter
                }
            }

            Column {

                PushButton {
                    id: mostViewedButton

                    width: 120
                    height: 120
                    smooth: true
                    icon: "ui-images/mostviewedicon.png"
                    iconWidth: 100
                    iconHeight: 100

                    Connections {
                        onButtonClicked: mostViewed()
                    }
                }

                Text {
                    x: 0
                    y: 10
                    width: 120
                    text: "Most Viewed"
                    font.pixelSize: smallFontSize
                    color: "white"
                    horizontalAlignment: Text.AlignHCenter
                }
            }

            Column {

                PushButton {
                    id: archiveButton

                    width: 120
                    height: 120
                    smooth: true
                    icon: "ui-images/downloadicon.png"
                    iconWidth: 100
                    iconHeight: 100

                    Connections {
                        onButtonClicked: archive()
                    }
                }

                Text {
                    x: 0
                    y: 10
                    width: 120
                    text: "Archive"
                    font.pixelSize: smallFontSize
                    color: "white"
                    horizontalAlignment: Text.AlignHCenter
                }
            }
        }

        MouseArea {
            id: mouseArea

            anchors.fill: dimmer
            enabled: false
            onClicked: closeDialogs()
        }

        states: State {
            name: "dim"
            PropertyChanges { target: dimmer; opacity: 0.3 }
        }

        transitions: Transition {
            PropertyAnimation { target: dimmer; properties: "opacity"; duration: 500 }
        }
    }

    states: State {
        name: "portrait"
        when: window.height > window.width
        PropertyChanges { target: buttonGrid; columns: 2 }
    }
}
