import QtQuick 1.0

Item {

    property string title
    property int index

    signal close

    function setVideo(videoTitle, videoIndex) {
        /* Set the dialog properties */

        title = videoTitle;
        index = videoIndex;
    }

    id: dialog
    width: 400
    height: 200

    Rectangle {
        id: background

        color: "black"
        radius: 10
        opacity: 0.5
        width: parent.width; height: parent.height
        border.width: 2
        border.color: activeColor
    }

    PushButton {
        id: resumeButton

        width: 100
        height: 100
        icon: "ui-images/downloadicon.png"
        iconWidth: 60
        iconHeight: 60
        anchors { verticalCenter: dialog.verticalCenter; left: dialog.left; margins: 25 }

        Connections {
            onButtonClicked: {
                DownloadManager.resumeDownload(index);
                close();
            }
        }
    }

    PushButton {
        id: pauseButton

        width: 100
        height: 100
        icon: "ui-images/pauseicon.png"
        anchors { horizontalCenter: dialog.horizontalCenter; verticalCenter: dialog.verticalCenter }

        Connections {
            onButtonClicked: {
                DownloadManager.pauseDownload(index);
                close();
            }
        }
    }

    PushButton {
        id: cancelButton

        width: 100
        height: 100
        icon: "ui-images/deleteicon.png"
        iconWidth: 68
        iconHeight: 68
        anchors { verticalCenter: dialog.verticalCenter; right: dialog.right; margins: 25 }

        Connections {
            onButtonClicked: {
                DownloadManager.cancelDownload(index);
                close();
            }
        }
    }

    Text {
        id: titleText

        width: dialog.width
        anchors { top: dialog.top; left: dialog.left; right: dialog.right; margins: 10 }
        elide: Text.ElideRight
        horizontalAlignment: Text.AlignHCenter
        font.pixelSize: smallFontSize
        color: "white"
        text: title
    }
}
