import QtQuick 1.0
import "settings.js" as Settings

Item {
    id: dialog

    property variant accounts : []

    signal currentUserChanged()

    function getAccounts() {
        /* Retrieve the user's accounts and populate the model */

        accounts = Settings.getAllAccounts();
        if (accounts != "unknown") {
            for (var i = 0; i < accounts.length; i++) {
                var username = accounts[i][0];
                accountsModel.append({ "username": username });
                if (username == YouTube.currentUser) {
                    accountsList.currentIndex = i;
                }
            }
        }
    }

    width: 600
    height: 300

    Component.onCompleted: getAccounts()

    Rectangle {
        id: background

        anchors.fill: dialog
        color: "black"
        opacity: 0.5
        radius: 10
        border.width: 2
        border.color: activeColor
    }

    Text {
        anchors { horizontalCenter: dialog.horizontalCenter; top: dialog.top; topMargin: 10 }
        text: "Change Current User"
        font.pixelSize: smallFontSize
        color: "white"
    }

    ListView {
        id: accountsList

        anchors { fill: dialog; leftMargin: 10; rightMargin: 10; topMargin: 50; bottomMargin: 10 }
        clip: true
        interactive: visibleArea.heightRatio < 1

        model: ListModel {
            id: accountsModel

        }

        delegate: AccountDelegate {
            id: delegate

            Connections {
                onDelegateClicked: {
                    accountsList.currentIndex = index;
                    YouTube.login(accounts[index][0], accounts[index][1]);
                    currentUserChanged();
                }
            }
        }

        ScrollBar {}
    }

    MouseArea {
        z: -1
        anchors.fill: dialog
    }

    states: State {
        name: "portrait"
        PropertyChanges { target: dialog; width: 460 }
    }
}
