/* Video info functions */

function getDuration(secs) {
    /* Convert seconds to HH:MM:SS format. */

    var hours = Math.floor(secs / 3600);
    var minutes = Math.floor(secs / 60) - (hours * 60);
    var seconds = secs - (hours * 3600) - ( minutes * 60);
    if (seconds < 10) {
        seconds = "0" + seconds;
    }
    var duration = minutes + ":" + seconds;
    if (hours > 0) {
        duration = hours + ":" + duration;
    }
    return duration;
}

function showRateVideoDialog() {
    if (dialog.source == "") {
        dialog.source = "RateVideoDialog.qml";
        dialog.item.likeClicked.connect(likeVideo);
        dialog.item.dislikeClicked.connect(dislikeVideo);
        dimmer.state = "dim";
        mouseArea.enabled = true;
    }
}

function likeVideo() {
    YouTube.rateVideo(videoId, "like");
    closeDialogs();
}

function dislikeVideo() {
    YouTube.rateVideo(videoId, "dislike");
    closeDialogs();
}

function showPlaylistDialog() {
    if (dialog.source == "") {
        dialog.source = "AddToPlaylistDialog.qml";
        dialog.item.playlistClicked.connect(addVideoToPlaylist);
        dimmer.state = "dim";
        mouseArea.enabled = true;
    }
}

function addVideoToPlaylist(playlistId) {
    YouTube.addToPlaylist(videoId, playlistId);
    closeDialogs();
}

function showAddCommentDialog() {
    /* Add a new comment */

    if (dialog.source == "") {
        dialog.source = "AddCommentDialog.qml";
        dialog.item.submitClicked.connect(addComment);
        dimmer.state = "dim";
        mouseArea.enabled = true;
    }
}

function showReplyToCommentDialog(author, commentId) {
    /* Reply to the selected comment */

    if (dialog.source == "") {
        dialog.source = "AddCommentDialog.qml";
        dialog.item.replyToComment(author, commentId);
        dialog.item.replyClicked.connect(replyToComment);
        dimmer.state = "dim";
        mouseArea.enabled = true;
    }
}

function addComment(comment) {
    /* Add a comment to the video */

    YouTube.addComment(videoId, comment);
    closeDialogs();
}

function replyToComment(commentId, comment) {
    /* Reply to another comment */

    YouTube.replyToComment(videoId, commentId, comment);
    closeDialogs();
}

function showShareDialog() {
    if (dialog.source == "") {
        dialog.source = "ShareDialog.qml";
        dialog.item.setLink(videoId);
        dialog.item.close.connect(closeDialogs);
        dimmer.state = "dim";
        mouseArea.enabled = true;
    }
}

function rotateDialogs() {
    if (dialog.source != "") {
        dialog.item.state = window.state;
    }
}

function closeDialogs() {
    /* Close any open dialogs and return the window to its default state */

    dialog.state = "";
    timer.running = true;
    dimmer.state = "";
    mouseArea.enabled = false;
}
