import QtQuick 1.0
import "settings.js" as Settings

Item {
    id: dialog

    property string downloadPath

    signal close
    signal settingChosen(string setting)

    function resetDialog() {
        /* Reset text input field */

        if (dialog.opacity == 0) {
            title.text = downloadPath;
        }
    }

    function checkDownloadPath(path) {
        /* Check that the path exists before saving */

        if (Controller.pathExists(path)) {
            settingChosen(path);
            dialog.opacity = 0;
            close();
        }
        else {
            displayMessage("Location does not exist. Please check.");
        }
    }

    width: 600
    height: 150
    opacity: 0

    Behavior on opacity { PropertyAnimation { properties: "opacity"; duration: 500 } }

    onOpacityChanged: resetDialog()

    Component.onCompleted: downloadPath = Settings.getSetting("downloadPath")

    Rectangle {
        id: background

        anchors.fill: dialog
        color: "black"
        opacity: 0.5
        radius: 10
        border.width: 2
        border.color: activeColor
    }

    Text {
        id: title

        anchors { horizontalCenter: dialog.horizontalCenter; top: dialog.top; topMargin: 10 }
        font.pixelSize: smallFontSize
        color: "white"
        text: "Download path"
    }

    Rectangle {
        id: downloadPathRect

        height: 50
        anchors { left: dialog.left; leftMargin: 10; right: dialog.right; rightMargin: 180; top: dialog.top; topMargin: 90 }
        color:  "white"
        border.width: 2
        border.color: activeColorLow
        radius: 5

        TextInput {
            id: downloadPathInput

            anchors { fill: parent; margins: 2 }
            focus: true
            font.pixelSize: standardFontSize
            selectByMouse: true
            selectionColor: activeColorLow
            text: downloadPath
        }
    }

    CloseButton {
        id: closeButton

        onButtonClicked: {
            dialog.opacity = 0;
            close();
        }
    }

    PushButton {
        id: saveButton

        anchors { right: dialog.right; bottom: dialog.bottom; margins: 10 }
        icon: "ui-images/tick.png"

        Connections {
            onButtonClicked: {
                var path = downloadPathInput.text;
                if (path != "") {
                    if (path.lastIndexOf("/") != path.length - 1) {
                        path = path + "/";
                    }
                    checkDownloadPath(path);
                }
            }
        }
    }

    MouseArea {
        z: -1
        anchors.fill: dialog
    }

    states: State {
        name: "portrait"
        PropertyChanges { target: dialog; width: 460; height: 190 }
        PropertyChanges { target: downloadPathRect; anchors.rightMargin: 10 }
        PropertyChanges { target: saveButton; buttonWidth: 440 }
    }
}
