import QtQuick 1.0

Item {

    property alias playlistTitle: title.text

    signal playClicked
    signal downloadClicked
    signal infoClicked

    id: dialog
    width: 400
    height: 200

    Rectangle {
        id: background
        color: "black"
        radius: 10
        opacity: 0.7
        width: parent.width; height: parent.height
        border.width: 2
        border.color: activeColor
    }
    PushButton {
        id: playButton

        buttonWidth: 100
        buttonHeight: 100
        icon: "ui-images/playicon.png"
        anchors { verticalCenter: dialog.verticalCenter; left: dialog.left; margins: 25 }

        Connections {
            onButtonClicked: playClicked()
        }
    }
    PushButton {
        id: downloadButton

        buttonWidth: 100
        buttonHeight: 100
        icon: "ui-images/downloadicon.png"
        iconWidth: 60
        iconHeight: 60
        anchors { horizontalCenter: dialog.horizontalCenter; verticalCenter: dialog.verticalCenter }

        Connections {
            onButtonClicked: downloadClicked()
        }
    }
    PushButton {
        id: infoButton

        buttonWidth: 100
        buttonHeight: 100
        icon: "ui-images/videosicon.png"
        anchors { verticalCenter: dialog.verticalCenter; right: dialog.right; margins: 25 }

        Connections {
            onButtonClicked: infoClicked()
        }
    }
    Text {
        id: title
        width: dialog.width
        anchors { top: dialog.top; left: dialog.left; right: dialog.right; margins: 10 }
        elide: Text.ElideRight
        horizontalAlignment: Text.AlignHCenter
        font.pixelSize: smallFontSize
        color: "white"
    }

    MouseArea {
        z: -1
        anchors.fill: dialog
    }
}
