import QtQuick 1.0

Rectangle {
    id: delegate

    property alias checked : checkbox.visible

    signal delegateClicked
    signal delegatePressed

    width: delegate.ListView.view.width; height: 100
    color: "black"
    smooth: true

    ListHighlight {
        visible: mouseArea.pressed
    }

    Text {
        id: titleText

        elide: Text.ElideRight
        text: title
        color: "white"
        font.pixelSize: standardFontSize
        anchors { left: frame.right; leftMargin: 5; right: progressBar.left; rightMargin: 5; top: frame.top }
        verticalAlignment: Text.AlignTop
        smooth: true
    }

    Text {
        id: statusText

        elide: Text.ElideRight
        text: status
        color: status == "Paused" || status == "Queued" ? "grey" : status == "Failed" ? "red" : activeColorLow
        font.pixelSize: smallFontSize
        anchors { left: frame.right; leftMargin: 8; bottom: frame.bottom }
        verticalAlignment: Text.AlignBottom
        smooth: true
    }

    Rectangle {
        id: frame

        width: 124
        height: 94
        anchors { left: delegate.left; leftMargin: 3; verticalCenter: delegate.verticalCenter }
        color: "black"
        border.width: 2
        border.color: "white"
        smooth: true
    }

    Image {
        id: thumb

        width: 120
        height: 90
        sourceSize.width: 120
        sourceSize.height: 90
        anchors.centerIn: frame
        source: thumb.status == Image.Error ? "ui-images/error.jpg" : thumbnail
        smooth: true
    }

    ProgressBar {
        id: progressBar

        anchors { verticalCenter: delegate.verticalCenter; right: delegate.right; rightMargin: 8 }
        received: bytesReceived
        total: totalBytes
    }

    Image {
        id: checkbox

        width: 70
        height: 70
        source: "ui-images/tick.png"
        visible: false
        smooth: true
        anchors {
            verticalCenter: parent.verticalCenter
            right: parent.right
            rightMargin: 5
        }
    }

    Rectangle {
        height: 1
        anchors { bottom: delegate.bottom; left: delegate.left; leftMargin: 10; right: delegate.right; rightMargin: 10 }
        color: activeColor
        opacity: 0.5
        visible: !(index == delegate.ListView.view.count - 1)
    }

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        onClicked: delegateClicked()
        onPressAndHold: delegatePressed()
    }
}

